/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.ldn;

import java.sql.SQLException;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.service.NotifyService;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotifyServiceDescriptionAddOperation
extends PatchOperation<NotifyServiceEntity> {
    @Autowired
    private NotifyService notifyService;
    private static final String OPERATION_PATH = "/description";

    @Override
    public NotifyServiceEntity perform(Context context, NotifyServiceEntity notifyServiceEntity, Operation operation) throws SQLException {
        this.checkOperationValue(operation.getValue());
        Object description = operation.getValue();
        if (description == null | !(description instanceof String)) {
            throw new UnprocessableEntityException("The /description value must be a string");
        }
        this.checkNonExistingDescriptionValue(notifyServiceEntity);
        notifyServiceEntity.setDescription((String)description);
        this.notifyService.update(context, notifyServiceEntity);
        return notifyServiceEntity;
    }

    void checkNonExistingDescriptionValue(NotifyServiceEntity notifyServiceEntity) {
        if (notifyServiceEntity.getDescription() != null) {
            throw new DSpaceBadRequestException("Attempting to add a value to an already existing path.");
        }
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof NotifyServiceEntity && operation.getOp().trim().equalsIgnoreCase("add") && operation.getPath().trim().toLowerCase().equalsIgnoreCase(OPERATION_PATH);
    }
}

