/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.model.SuggestionTargetRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.suggestion.SuggestionService;
import org.dspace.app.suggestion.SuggestionTarget;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="integration.suggestiontargets")
public class SuggestionTargetRestRepository
extends DSpaceRestRepository<SuggestionTargetRest, String> {
    private static final Logger log = LogManager.getLogger(SuggestionTargetRestRepository.class);
    @Autowired
    private SuggestionService suggestionService;

    @Override
    @PreAuthorize(value="hasPermission(#id, 'SUGGESTIONTARGET', 'READ')")
    public SuggestionTargetRest findOne(Context context, String id) {
        String source = null;
        UUID uuid = null;
        try {
            source = id.split(":")[0];
            uuid = UUID.fromString(id.split(":")[1]);
        }
        catch (Exception e) {
            return null;
        }
        SuggestionTarget suggestionTarget = this.suggestionService.find(context, source, uuid);
        if (suggestionTarget == null) {
            return null;
        }
        return (SuggestionTargetRest)this.converter.toRest(suggestionTarget, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="permitAll()")
    public Page<SuggestionTargetRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("suggestiontarget", "findAll");
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    @SearchRestMethod(name="findBySource")
    public Page<SuggestionTargetRest> findBySource(@Parameter(required=true, value="source") String source, Pageable pageable) {
        Context context = this.obtainContext();
        List suggestionTargets = this.suggestionService.findAllTargets(context, source, pageable.getPageSize(), pageable.getOffset());
        long tot = this.suggestionService.countAll(context, source);
        if (suggestionTargets == null) {
            return null;
        }
        return this.converter.toRestPage(suggestionTargets, pageable, tot, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasPermission(#target, 'SUGGESTIONTARGET.TARGET', 'READ')")
    @SearchRestMethod(name="findByTarget")
    public Page<SuggestionTargetRest> findByTarget(@Parameter(required=true, value="target") UUID target, Pageable pageable) {
        Context context = this.obtainContext();
        List suggestionTargets = this.suggestionService.findByTarget(context, target, pageable.getPageSize(), pageable.getOffset());
        long tot = this.suggestionService.countAllByTarget(context, target);
        if (suggestionTargets == null) {
            return null;
        }
        return this.converter.toRestPage(suggestionTargets, pageable, tot, this.utils.obtainProjection());
    }

    @Override
    public Class<SuggestionTargetRest> getDomainClass() {
        return SuggestionTargetRest.class;
    }
}

