/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.UUID;
import javax.annotation.Nullable;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.items.submitter")
public class ItemSubmitterLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    ItemService itemService;

    @PreAuthorize(value="hasPermission(#id, 'ITEM', 'READ')")
    public EPersonRest getItemSubmitter(@Nullable HttpServletRequest request, UUID id, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Item item = (Item)this.itemService.find(context, id);
            if (item == null) {
                throw new ResourceNotFoundException("No such item: " + id);
            }
            return (EPersonRest)this.converter.toRest(item.getSubmitter(), projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

