/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.RESTAuthorizationException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.CorrectionTypeRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.correctiontype.CorrectionType;
import org.dspace.correctiontype.service.CorrectionTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.correctiontypes")
public class CorrectionTypeRestRepository
extends DSpaceRestRepository<CorrectionTypeRest, String> {
    @Autowired
    private ItemService itemService;
    @Autowired
    private CorrectionTypeService correctionTypeService;

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public CorrectionTypeRest findOne(Context context, String id) {
        CorrectionType correctionType = this.correctionTypeService.findOne(id);
        return Objects.nonNull(correctionType) ? (CorrectionTypeRest)this.converter.toRest(correctionType, this.utils.obtainProjection()) : null;
    }

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<CorrectionTypeRest> findAll(Context context, Pageable pageable) {
        return this.converter.toRestPage(this.correctionTypeService.findAll(), pageable, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    @SearchRestMethod(name="findByItem")
    public Page<CorrectionTypeRest> findByItem(@Parameter(value="uuid", required=true) UUID uuid, Pageable pageable) {
        Context context = this.obtainContext();
        try {
            List correctionTypes;
            Item item = (Item)this.itemService.find(context, uuid);
            if (Objects.isNull(item)) {
                throw new UnprocessableEntityException("Item with uuid:" + uuid + " not found");
            }
            try {
                correctionTypes = this.correctionTypeService.findByItem(context, item);
            }
            catch (AuthorizeException e) {
                throw new RESTAuthorizationException(e);
            }
            return this.converter.toRestPage(correctionTypes, pageable, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    @SearchRestMethod(name="findByTopic")
    public CorrectionTypeRest findByTopic(@Parameter(value="topic", required=true) String topic) {
        CorrectionType correctionType = this.correctionTypeService.findByTopic(topic);
        return Objects.nonNull(correctionType) ? (CorrectionTypeRest)this.converter.toRest(correctionType, this.utils.obtainProjection()) : null;
    }

    @Override
    public Class<CorrectionTypeRest> getDomainClass() {
        return CorrectionTypeRest.class;
    }
}

