/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.service.BundleService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.bundles.item")
public class BundleItemLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    BundleService bundleService;

    @PreAuthorize(value="hasPermission(#bundleId, 'BUNDLE', 'READ')")
    public ItemRest getItem(@Nullable HttpServletRequest request, UUID bundleId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Bundle bundle = (Bundle)this.bundleService.find(context, bundleId);
            if (bundle == null) {
                throw new ResourceNotFoundException("No such bundle: " + bundleId);
            }
            Item item = (Item)bundle.getItems().get(0);
            if (item == null) {
                return null;
            }
            return (ItemRest)this.converter.toRest(item, projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

