/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.rest.model.BundleRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.bitstreams.bundle")
public class BitstreamBundleLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    BitstreamService bitstreamService;

    @PreAuthorize(value="hasPermission(#bitstreamId, 'BITSTREAM', 'READ')")
    public BundleRest getBundle(@Nullable HttpServletRequest request, UUID bitstreamId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Bitstream bitstream = this.bitstreamService.find(context, bitstreamId);
            if (bitstream == null) {
                throw new ResourceNotFoundException("No such bitstream: " + bitstreamId);
            }
            if (bitstream.getBundles().isEmpty()) {
                return null;
            }
            return (BundleRest)this.converter.toRest((Bundle)bitstream.getBundles().get(0), projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

