/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.model.RootRest;
import org.dspace.app.util.Util;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RootConverter {
    @Autowired
    private ConfigurationService configurationService;

    public RootRest convert(HttpServletRequest request) {
        RootRest rootRest = new RootRest();
        rootRest.setDspaceName(this.configurationService.getProperty("dspace.name"));
        rootRest.setDspaceUI(this.configurationService.getProperty("dspace.ui.url"));
        String requestUrl = request.getRequestURL().toString();
        String dspaceUrl = this.configurationService.getProperty("dspace.server.url");
        String dspaceSSRUrl = this.configurationService.getProperty("dspace.server.ssr.url", dspaceUrl);
        if (!dspaceUrl.equals(dspaceSSRUrl) && StringUtils.isNotBlank((CharSequence)dspaceSSRUrl) && requestUrl.startsWith(dspaceSSRUrl)) {
            rootRest.setDspaceServer(dspaceSSRUrl);
        } else {
            rootRest.setDspaceServer(dspaceUrl);
        }
        rootRest.setDspaceVersion("DSpace " + Util.getSourceVersion());
        return rootRest;
    }
}

