/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueList;
import org.dspace.app.rest.model.PotentialDuplicateRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.content.virtual.PotentialDuplicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PotentialDuplicateConverter
implements DSpaceConverter<PotentialDuplicate, PotentialDuplicateRest> {
    @Lazy
    @Autowired
    private ConverterService converter;

    @Override
    public PotentialDuplicateRest convert(PotentialDuplicate modelObject, Projection projection) {
        if (modelObject == null) {
            return null;
        }
        PotentialDuplicateRest rest = new PotentialDuplicateRest();
        rest.setUuid(modelObject.getUuid());
        rest.setTitle(modelObject.getTitle());
        rest.setOwningCollectionName(modelObject.getOwningCollectionName());
        rest.setWorkflowItemId(modelObject.getWorkflowItemId());
        rest.setWorkspaceItemId(modelObject.getWorkspaceItemId());
        rest.setMetadata((MetadataRest)this.converter.toRest(new MetadataValueList(modelObject.getMetadataValueList()), projection));
        return rest;
    }

    @Override
    public Class<PotentialDuplicate> getModelClass() {
        return PotentialDuplicate.class;
    }
}

