/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.app.rest.model.FacetConfigurationRest;
import org.dspace.app.rest.model.SearchFacetEntryRest;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.springframework.stereotype.Component;

@Component
public class DiscoverFacetConfigurationConverter {
    public FacetConfigurationRest convert(String configurationName, String scope, DiscoveryConfiguration configuration) {
        FacetConfigurationRest facetConfigurationRest = new FacetConfigurationRest();
        facetConfigurationRest.setConfiguration(configurationName);
        facetConfigurationRest.setScope(scope);
        if (configuration != null) {
            this.addSidebarFacets(facetConfigurationRest, configuration.getSidebarFacets());
        }
        return facetConfigurationRest;
    }

    private void addSidebarFacets(FacetConfigurationRest facetConfigurationRest, List<DiscoverySearchFilterFacet> sidebarFacets) {
        for (DiscoverySearchFilterFacet discoverySearchFilterFacet : CollectionUtils.emptyIfNull(sidebarFacets)) {
            SearchFacetEntryRest facetEntry = new SearchFacetEntryRest(discoverySearchFilterFacet.getIndexFieldName());
            facetEntry.setFacetType(discoverySearchFilterFacet.getType());
            facetEntry.setFacetLimit(discoverySearchFilterFacet.getFacetLimit());
            facetEntry.setOpenByDefault(discoverySearchFilterFacet.isOpenByDefault());
            facetConfigurationRest.addSidebarFacet(facetEntry);
        }
    }
}

