/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.sql.SQLException;
import java.util.List;
import org.dspace.app.rest.converter.DSpaceObjectConverter;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.CheckSumRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.springframework.stereotype.Component;

@Component
public class BitstreamConverter
extends DSpaceObjectConverter<Bitstream, BitstreamRest> {
    @Override
    public BitstreamRest convert(Bitstream obj, Projection projection) {
        BitstreamRest b = (BitstreamRest)super.convert(obj, projection);
        b.setSequenceId(obj.getSequenceID());
        List bundles = null;
        try {
            bundles = obj.getBundles();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        if (bundles != null && bundles.size() > 0) {
            b.setBundleName(((Bundle)bundles.get(0)).getName());
        }
        CheckSumRest checksum = new CheckSumRest();
        checksum.setCheckSumAlgorithm(obj.getChecksumAlgorithm());
        checksum.setValue(obj.getChecksum());
        b.setCheckSum(checksum);
        b.setSizeBytes(obj.getSizeBytes());
        return b;
    }

    @Override
    protected BitstreamRest newInstance() {
        return new BitstreamRest();
    }

    @Override
    public Class<Bitstream> getModelClass() {
        return Bitstream.class;
    }
}

