/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canSeeQA", description="It can be used to verify if the user can manage Quality Assurance events")
public class QAAuthorizationFeature
implements AuthorizationFeature {
    public static final String NAME = "canSeeQA";
    @Autowired
    private ConfigurationService configurationService;

    @Override
    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        return this.configurationService.getBooleanProperty("qaevents.enabled", false);
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"core.site"};
    }
}

