/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.core.Context;
import org.dspace.services.RequestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="epersonRegistration", description="It can be used to register an eperson")
public class EPersonRegistrationFeature
implements AuthorizationFeature {
    public static final String NAME = "epersonRegistration";
    @Autowired
    private RequestService requestService;

    @Override
    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (!(object instanceof SiteRest)) {
            return false;
        }
        return AuthorizeUtil.authorizeNewAccountRegistration((Context)context, (HttpServletRequest)this.requestService.getCurrentRequest().getHttpServletRequest());
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"core.site"};
    }
}

