/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canManageBitstreamBundles", description="It can be used to verify if the user can manage (ADD | REMOVE) the bundles of bitstreams of an Item")
public class CanManageBitstreamBundlesFeature
implements AuthorizationFeature {
    public static final String NAME = "canManageBitstreamBundles";
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private Utils utils;

    @Override
    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (object instanceof ItemRest) {
            DSpaceObject dSpaceObject = (DSpaceObject)this.utils.getDSpaceAPIObjectFromRest(context, object);
            boolean hasRemovePermission = this.authorizeService.authorizeActionBoolean(context, context.getCurrentUser(), dSpaceObject, 4, true);
            boolean hasAddPermission = this.authorizeService.authorizeActionBoolean(context, context.getCurrentUser(), dSpaceObject, 3, true);
            return hasRemovePermission && hasAddPermission;
        }
        return false;
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"core.item"};
    }
}

