/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.UUID;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.BundleRest;
import org.dspace.app.rest.model.hateoas.BundleResource;
import org.dspace.app.rest.repository.BundlePrimaryBitstreamLinkRepository;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/core/bundles/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}/primaryBitstream"})
public class PrimaryBitstreamController {
    @Autowired
    private BundlePrimaryBitstreamLinkRepository repository;
    @Autowired
    private ConverterService converter;
    @Autowired
    private Utils utils;

    @PreAuthorize(value="hasPermission(#uuid, 'BUNDLE', 'WRITE')")
    @RequestMapping(method={RequestMethod.POST}, consumes={"text/uri-list"})
    public ResponseEntity<RepresentationModel<?>> createPrimaryBitstream(@PathVariable UUID uuid, HttpServletRequest request) {
        Context context = ContextUtil.obtainContext(request);
        BundleRest bundleRest = this.repository.createPrimaryBitstream(context, uuid, this.getBitstreamFromRequest(context, request), this.utils.obtainProjection());
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), this.converter.toResource(bundleRest));
    }

    @PreAuthorize(value="hasPermission(#uuid, 'BUNDLE', 'WRITE')")
    @RequestMapping(method={RequestMethod.PUT}, consumes={"text/uri-list"})
    public BundleResource updatePrimaryBitstream(@PathVariable UUID uuid, HttpServletRequest request) {
        Context context = ContextUtil.obtainContext(request);
        BundleRest bundleRest = this.repository.updatePrimaryBitstream(context, uuid, this.getBitstreamFromRequest(context, request), this.utils.obtainProjection());
        return (BundleResource)((Object)this.converter.toResource(bundleRest));
    }

    @PreAuthorize(value="hasPermission(#uuid, 'BUNDLE', 'WRITE')")
    @RequestMapping(method={RequestMethod.DELETE})
    public ResponseEntity<RepresentationModel<?>> deletePrimaryBitstream(@PathVariable UUID uuid, HttpServletRequest request) {
        Context context = ContextUtil.obtainContext(request);
        this.repository.deletePrimaryBitstream(context, uuid);
        return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.NO_CONTENT);
    }

    private Bitstream getBitstreamFromRequest(Context context, HttpServletRequest request) {
        List<DSpaceObject> dsoList = this.utils.constructDSpaceObjectList(context, this.utils.getStringListFromRequest(request));
        if (dsoList.size() != 1 || dsoList.get(0).getType() != 0) {
            throw new UnprocessableEntityException("URI does not resolve to an existing bitstream.");
        }
        return (Bitstream)dsoList.get(0);
    }
}

