/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.ldn.LDNMessageEntity;
import org.dspace.app.ldn.LDNRouter;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.model.Notification;
import org.dspace.app.ldn.service.LDNMessageService;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.InvalidLDNMessageException;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.web.ContextUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.server.ResponseStatusException;

@Controller
@RequestMapping(value={"/ldn"})
@ConditionalOnProperty(value={"ldn.enabled"})
public class LDNInboxController {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private LDNRouter router;
    @Autowired
    private LDNMessageService ldnMessageService;
    @Autowired
    private ConfigurationService configurationService;

    @PostMapping(value={"/inbox"}, consumes={"application/ld+json"})
    public ResponseEntity<Object> inbox(HttpServletRequest request, @RequestBody Notification notification) throws Exception {
        Context context = ContextUtil.obtainCurrentRequestContext();
        this.validate(context, notification, request.getRemoteAddr());
        LDNMessageEntity ldnMsgEntity = this.ldnMessageService.create(context, notification, request.getRemoteAddr());
        log.info("stored ldn message {}", (Object)ldnMsgEntity);
        context.commit();
        return ResponseEntity.accepted().body((Object)String.format("Successfully stored notification %s %s", notification.getId(), notification.getType()));
    }

    @RequestMapping(value={"/inbox"}, method={RequestMethod.OPTIONS})
    public ResponseEntity<Void> options() {
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().allow(new HttpMethod[]{HttpMethod.OPTIONS, HttpMethod.POST})).header("Accept-Post", new String[]{"application/ld+json"})).build();
    }

    @ExceptionHandler(value={ResponseStatusException.class})
    public ResponseEntity<String> handleResponseStatusException(ResponseStatusException e) {
        return ResponseEntity.status((int)e.getStatusCode().value()).body((Object)e.getMessage());
    }

    private void validate(Context context, Notification notification, String sourceIp) {
        NotifyServiceEntity originNotifyService;
        String id = notification.getId();
        Pattern URNRegex = Pattern.compile("^urn:uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");
        if (!URNRegex.matcher(id).matches() && !new UrlValidator().isValid(id)) {
            throw new InvalidLDNMessageException("Invalid URI format for 'id' field.");
        }
        if (notification.getOrigin() == null || notification.getTarget() == null || notification.getObject() == null) {
            throw new InvalidLDNMessageException("Origin or Target or Object is missing");
        }
        if (this.configurationService.getBooleanProperty("ldn.notify.inbox.block-untrusted", true)) {
            try {
                originNotifyService = this.ldnMessageService.findNotifyService(context, notification.getOrigin());
                if (originNotifyService == null) {
                    throw new DSpaceBadRequestException("Notify Service [" + notification.getOrigin() + "] unknown. LDN message can not be received.");
                }
            }
            catch (SQLException sqle) {
                throw new DSpaceBadRequestException("Notify Service [" + notification.getOrigin() + "] unknown. LDN message can not be received.");
            }
        }
        if (this.configurationService.getBooleanProperty("ldn.notify.inbox.block-untrusted-ip", true)) {
            try {
                originNotifyService = this.ldnMessageService.findNotifyService(context, notification.getOrigin());
                if (originNotifyService == null) {
                    throw new DSpaceBadRequestException("Notify Service [" + notification.getOrigin() + "] unknown. LDN message can not be received.");
                }
                boolean isValidIp = this.ldnMessageService.isValidIp(originNotifyService, sourceIp);
                if (!isValidIp) {
                    throw new DSpaceBadRequestException("Source IP for Incoming LDN Message [" + notification.getId() + "] out of its Notify Service IP Range. LDN message can not be received.");
                }
            }
            catch (SQLException sqle) {
                throw new DSpaceBadRequestException("Notify Service [" + notification.getOrigin() + "] unknown. LDN message can not be received.");
            }
        }
    }
}

