/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.model.ContentReportSupportRest;
import org.dspace.app.rest.model.FilteredCollectionsQuery;
import org.dspace.app.rest.model.FilteredCollectionsRest;
import org.dspace.app.rest.model.FilteredItemsQueryPredicate;
import org.dspace.app.rest.model.FilteredItemsQueryRest;
import org.dspace.app.rest.model.FilteredItemsRest;
import org.dspace.app.rest.model.hateoas.ContentReportSupportResource;
import org.dspace.app.rest.model.hateoas.FilteredCollectionsResource;
import org.dspace.app.rest.model.hateoas.FilteredItemsResource;
import org.dspace.app.rest.repository.ContentReportRestRepository;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.contentreport.Filter;
import org.dspace.contentreport.service.ContentReportService;
import org.dspace.core.Context;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contentreport"})
public class ContentReportRestController
implements InitializingBean {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private DiscoverableEndpointsService discoverableEndpointsService;
    @Autowired
    private ConverterService converter;
    @Autowired
    private ContentReportRestRepository contentReportRestRepository;
    @Autowired
    private ContentReportService contentReportService;

    public void afterPropertiesSet() throws Exception {
        this.discoverableEndpointsService.register(this, List.of(Link.of((String)"/api/contentreport", (String)"contentreport")));
    }

    @RequestMapping(method={RequestMethod.GET})
    public ContentReportSupportResource getContentReportSupport() {
        ContentReportSupportRest contentReportSupportRest = this.contentReportRestRepository.getContentReportSupport();
        return (ContentReportSupportResource)((Object)this.converter.toResource(contentReportSupportRest));
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    @GetMapping(value={"/filteredcollections"})
    public ResponseEntity<RepresentationModel<?>> getFilteredCollections(@RequestParam(name="filters", required=false) List<String> filters, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.contentReportService.getEnabled()) {
            Context context = ContextUtil.obtainContext(request);
            Set<Filter> filtersSet = ContentReportRestController.listToStream(filters).map(Filter::get).filter(f -> f != null).collect(Collectors.toSet());
            FilteredCollectionsQuery query = FilteredCollectionsQuery.of(filtersSet);
            return this.filteredCollectionsReport(context, query);
        }
        this.error404(response);
        return null;
    }

    private ResponseEntity<RepresentationModel<?>> filteredCollectionsReport(Context context, FilteredCollectionsQuery query) {
        FilteredCollectionsRest report = this.contentReportRestRepository.findFilteredCollections(context, query);
        FilteredCollectionsResource result = (FilteredCollectionsResource)((Object)this.converter.toResource(report));
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.OK, (HttpHeaders)new HttpHeaders(), (RepresentationModel)result);
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    @GetMapping(value={"/filtereditems"})
    public ResponseEntity<RepresentationModel<?>> getFilteredItems(@RequestParam(name="collections", required=false) List<String> collections, @RequestParam(name="queryPredicates", required=false) List<String> predicates, @RequestParam(name="pageNumber", defaultValue="0") String pageNumber, @RequestParam(name="pageLimit", defaultValue="10") String pageLimit, @RequestParam(name="filters", required=false) List<String> filters, @RequestParam(name="additionalFields", required=false) List<String> additionalFields, HttpServletRequest request, HttpServletResponse response, Pageable pageable) throws IOException {
        if (this.contentReportService.getEnabled()) {
            Context context = ContextUtil.obtainContext(request);
            String[] realPredicates = request.getParameterValues("queryPredicates");
            List collUuids = Optional.ofNullable(collections).orElseGet(() -> List.of());
            List<FilteredItemsQueryPredicate> preds = ContentReportRestController.arrayToStream(realPredicates).map(FilteredItemsQueryPredicate::of).collect(Collectors.toList());
            int pgLimit = ContentReportRestController.parseInt(pageLimit, 10);
            int pgNumber = ContentReportRestController.parseInt(pageNumber, 0);
            Pageable myPageable = pageable;
            if (pageable == null || pageable.getPageNumber() != pgNumber || pageable.getPageSize() != pgLimit) {
                Sort sort = Optional.ofNullable(pageable).map(Pageable::getSort).orElse(Sort.unsorted());
                myPageable = PageRequest.of((int)pgNumber, (int)pgLimit, (Sort)sort);
            }
            Set<Filter> filtersMap = ContentReportRestController.listToStream(filters).map(Filter::get).filter(f -> f != null).collect(Collectors.toSet());
            List addFields = Optional.ofNullable(additionalFields).orElseGet(() -> List.of());
            FilteredItemsQueryRest query = FilteredItemsQueryRest.of(collUuids, preds, pgLimit, filtersMap, addFields);
            return this.filteredItemsReport(context, query, myPageable);
        }
        this.error404(response);
        return null;
    }

    private static Stream<String> listToStream(Collection<String> array) {
        return Optional.ofNullable(array).stream().flatMap(Collection::stream).filter(StringUtils::isNotBlank);
    }

    private static Stream<String> arrayToStream(String ... array) {
        return Optional.ofNullable(array).stream().flatMap(Arrays::stream).filter(StringUtils::isNotBlank);
    }

    private static int parseInt(String value, int defaultValue) {
        return Optional.ofNullable(value).stream().mapToInt(Integer::parseInt).findFirst().orElse(defaultValue);
    }

    private ResponseEntity<RepresentationModel<?>> filteredItemsReport(Context context, FilteredItemsQueryRest query, Pageable pageable) {
        FilteredItemsRest report = this.contentReportRestRepository.findFilteredItems(context, query, pageable);
        FilteredItemsResource result = (FilteredItemsResource)((Object)this.converter.toResource(report));
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.OK, (HttpHeaders)new HttpHeaders(), (RepresentationModel)result);
    }

    private void error404(HttpServletResponse response) throws IOException {
        log.debug("Content Reports are disabled");
        String err = "Content Reports are disabled";
        response.setStatus(404);
        response.setContentType("text/html");
        response.setContentLength(err.length());
        response.getWriter().write(err);
    }
}

