/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.core.Context;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="epersonForgotPassword", description="It can be used to check password reset for an eperson")
public class EPersonForgotPasswordFeature
implements AuthorizationFeature {
    public static final String NAME = "epersonForgotPassword";

    @Override
    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        boolean isEperson = object instanceof EPersonRest;
        boolean isSite = object instanceof SiteRest;
        if (!isEperson && !isSite) {
            return false;
        }
        if (!AuthorizeUtil.authorizeForgotPassword()) {
            return false;
        }
        if (isEperson) {
            return AuthorizeUtil.authorizeUpdatePassword((Context)context, (String)((EPersonRest)object).getEmail());
        }
        return true;
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"core.site", "eperson.eperson"};
    }
}

