/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.hateoas.Link;
import org.springframework.stereotype.Service;

@Service
public class DiscoverableEndpointsService {
    private Map<Object, List<Link>> registeredEndpoints = new HashMap<Object, List<Link>>();
    private boolean initialized = false;
    private List<Link> discoverableEndpoints = new ArrayList<Link>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Object controller, List<Link> links) {
        DiscoverableEndpointsService discoverableEndpointsService = this;
        synchronized (discoverableEndpointsService) {
            this.initialized = false;
            this.registeredEndpoints.put(controller, links);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Object controller) {
        DiscoverableEndpointsService discoverableEndpointsService = this;
        synchronized (discoverableEndpointsService) {
            this.initialized = false;
            this.registeredEndpoints.remove(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Link> getDiscoverableEndpoints() {
        DiscoverableEndpointsService discoverableEndpointsService = this;
        synchronized (discoverableEndpointsService) {
            if (this.initialized) {
                return this.discoverableEndpoints;
            }
            this.discoverableEndpoints.clear();
            HashSet<String> rels = new HashSet<String>();
            for (Map.Entry<Object, List<Link>> controller : this.registeredEndpoints.entrySet()) {
                for (Link link : controller.getValue()) {
                    if (!this.isLinkValid(controller.getKey(), link.getHref())) continue;
                    this.discoverableEndpoints.add(link);
                    if (rels.contains(link.getRel().value())) {
                        throw new IllegalStateException("The rel " + link.getRel().value() + " is defined multiple times!");
                    }
                    rels.add(link.getRel().value());
                }
            }
            this.initialized = true;
            return this.discoverableEndpoints;
        }
    }

    private boolean isLinkValid(Object controller, String href) {
        return true;
    }
}

