/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.saml2;

import com.google.common.io.CharStreams;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.InMemoryRelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrations;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.stereotype.Component;

@Component
public class DSpaceRelyingPartyRegistrationRepository
implements RelyingPartyRegistrationRepository {
    private static final Logger logger = LoggerFactory.getLogger(DSpaceRelyingPartyRegistrationRepository.class);
    private RelyingPartyRegistrationRepository repository = null;

    public DSpaceRelyingPartyRegistrationRepository() {
        this.reload();
    }

    public RelyingPartyRegistration findByRegistrationId(String registrationId) {
        if (this.repository == null) {
            return null;
        }
        return this.repository.findByRegistrationId(registrationId);
    }

    public void reload() {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        List registrations = configurationService.getChildren("saml-relying-party").stream().map(relyingPartyConfiguration -> this.buildRelyingPartyRegistration((HierarchicalConfiguration<ImmutableNode>)relyingPartyConfiguration)).filter(registration -> registration != null).collect(Collectors.toList());
        this.repository = registrations.size() > 0 ? new InMemoryRelyingPartyRegistrationRepository(registrations) : null;
    }

    private RelyingPartyRegistration buildRelyingPartyRegistration(HierarchicalConfiguration<ImmutableNode> configuration) {
        String relyingPartyId = configuration.getRootElementName();
        try {
            HierarchicalConfiguration<ImmutableNode> assertingPartyConfiguration = this.getConfigurationAt(configuration, "asserting-party");
            if (assertingPartyConfiguration == null) {
                logger.warn("Couldn't find SAML asserting-party configuration for relying-party {}. Relying party will not be registered.", (Object)relyingPartyId);
                return null;
            }
            String metadataUri = assertingPartyConfiguration.getString("metadata-uri");
            RelyingPartyRegistration.Builder registrationBuilder = metadataUri != null ? RelyingPartyRegistrations.fromMetadataLocation((String)metadataUri).registrationId(relyingPartyId) : RelyingPartyRegistration.withRegistrationId((String)relyingPartyId);
            registrationBuilder.assertionConsumerServiceLocation("{baseUrl}/saml2/assertion-consumer/{registrationId}");
            registrationBuilder.assertingPartyDetails(assertingParty -> {
                List verificationCredentials;
                HierarchicalConfiguration<ImmutableNode> sloConfiguration;
                HierarchicalConfiguration<ImmutableNode> ssoConfiguration;
                String entityId = assertingPartyConfiguration.getString("entity-id");
                if (entityId != null) {
                    assertingParty.entityId(entityId);
                }
                if ((ssoConfiguration = this.getConfigurationAt(assertingPartyConfiguration, "single-sign-on")) != null) {
                    Boolean shouldSignRequest;
                    String binding;
                    String url = ssoConfiguration.getString("url");
                    if (url != null) {
                        assertingParty.singleSignOnServiceLocation(url);
                    }
                    if ((binding = ssoConfiguration.getString("binding")) != null) {
                        assertingParty.singleSignOnServiceBinding(Saml2MessageBinding.valueOf((String)binding.toUpperCase()));
                    }
                    if ((shouldSignRequest = ssoConfiguration.getBoolean("sign-request", null)) != null) {
                        assertingParty.wantAuthnRequestsSigned(shouldSignRequest.booleanValue());
                    }
                }
                if ((sloConfiguration = this.getConfigurationAt(assertingPartyConfiguration, "single-logout")) != null) {
                    String responseUrl;
                    String binding;
                    String url = sloConfiguration.getString("url");
                    if (url != null) {
                        assertingParty.singleLogoutServiceLocation(url);
                    }
                    if ((binding = sloConfiguration.getString("binding")) != null) {
                        assertingParty.singleLogoutServiceBinding(Saml2MessageBinding.valueOf((String)binding.toUpperCase()));
                    }
                    if ((responseUrl = sloConfiguration.getString("response-url")) != null) {
                        assertingParty.singleLogoutServiceResponseLocation(responseUrl);
                    }
                }
                if ((verificationCredentials = assertingPartyConfiguration.childConfigurationsAt("verification.credentials").stream().map(credentialsConfiguration -> credentialsConfiguration.getString("certificate-location")).filter(certificateLocation -> certificateLocation != null).map(certificateLocation -> this.certificateFromUrl((String)certificateLocation)).filter(certificate -> certificate != null).map(certificate -> Saml2X509Credential.verification((X509Certificate)certificate)).collect(Collectors.toList())).size() > 0) {
                    assertingParty.verificationX509Credentials(credentials -> {
                        credentials.clear();
                        credentials.addAll(verificationCredentials);
                    });
                }
            });
            configuration.childConfigurationsAt("signing.credentials").stream().forEach(credentialsConfiguration -> {
                String privateKeyLocation = credentialsConfiguration.getString("private-key-location");
                String certificateLocation = credentialsConfiguration.getString("certificate-location");
                PrivateKey privateKey = this.privateKeyFromUrl(privateKeyLocation);
                X509Certificate certificate = this.certificateFromUrl(certificateLocation);
                if (privateKey != null && certificate != null) {
                    registrationBuilder.signingX509Credentials(credentials -> credentials.add(Saml2X509Credential.signing((PrivateKey)privateKey, (X509Certificate)certificate)));
                }
            });
            configuration.childConfigurationsAt("decryption.credentials").stream().forEach(credentialsConfiguration -> {
                String privateKeyLocation = credentialsConfiguration.getString("private-key-location");
                String certificateLocation = credentialsConfiguration.getString("certificate-location");
                PrivateKey privateKey = this.privateKeyFromUrl(privateKeyLocation);
                X509Certificate certificate = this.certificateFromUrl(certificateLocation);
                if (privateKey != null && certificate != null) {
                    registrationBuilder.decryptionX509Credentials(credentials -> credentials.add(Saml2X509Credential.decryption((PrivateKey)privateKey, (X509Certificate)certificate)));
                }
            });
            return registrationBuilder.build();
        }
        catch (Exception e) {
            logger.error("Error building SAML relying party registration for id " + relyingPartyId, (Throwable)e);
            return null;
        }
    }

    private HierarchicalConfiguration<ImmutableNode> getConfigurationAt(HierarchicalConfiguration<ImmutableNode> configuration, String key) {
        try {
            return configuration.configurationAt(key);
        }
        catch (ConfigurationRuntimeException e) {
            return null;
        }
    }

    private PrivateKey privateKeyFromUrl(String url) {
        RSAPrivateKey rSAPrivateKey;
        if (url == null || url.length() == 0) {
            return null;
        }
        Resource resource = this.getResourceFromUrl(url);
        if (resource == null) {
            logger.error("Resource not found at private key url: " + url);
            return null;
        }
        if (!resource.exists()) {
            logger.error("No resource exists at private key url: " + url);
            return null;
        }
        InputStreamReader reader = new InputStreamReader(resource.getInputStream());
        try {
            String key = CharStreams.toString((Readable)reader);
            String privateKeyPEM = key.replace("-----BEGIN PRIVATE KEY-----", "").replaceAll(System.lineSeparator(), "").replace("-----END PRIVATE KEY-----", "");
            byte[] encoded = Base64.getDecoder().decode(privateKeyPEM);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
            rSAPrivateKey = (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                logger.error("Error reading private key from " + url, (Throwable)ex);
                return null;
            }
        }
        ((Reader)reader).close();
        return rSAPrivateKey;
    }

    private X509Certificate certificateFromUrl(String url) {
        X509Certificate x509Certificate;
        block11: {
            if (url == null || url.length() == 0) {
                return null;
            }
            Resource resource = this.getResourceFromUrl(url);
            if (resource == null) {
                logger.error("Resource not found at certificate url: " + url);
                return null;
            }
            if (!resource.exists()) {
                logger.error("No resource exists at certificate url: " + url);
                return null;
            }
            InputStream is = resource.getInputStream();
            try {
                x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(is);
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    logger.error("Error reading certificate from " + url, (Throwable)ex);
                    return null;
                }
            }
            is.close();
        }
        return x509Certificate;
    }

    private Resource getResourceFromUrl(String url) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        Resource resource = resourceLoader.getResource(url);
        return resource;
    }
}

