/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.dspace.core.ConfigurationManager;

public class FileUploadRequest
extends HttpServletRequestWrapper {
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, FileItem> fileitems = new HashMap<String, FileItem>();
    private List<String> filenames = new ArrayList<String>();
    private String tempDir = null;
    private HttpServletRequest original = null;

    public FileUploadRequest(HttpServletRequest req) throws IOException, FileUploadBase.FileSizeLimitExceededException {
        super(req);
        this.original = req;
        this.tempDir = ConfigurationManager.getProperty((String)"upload.temp.dir");
        long maxSize = ConfigurationManager.getLongProperty((String)"upload.max");
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setRepository(new File(this.tempDir));
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        try {
            upload.setSizeMax(maxSize);
            List items = upload.parseRequest(req);
            for (FileItem item : items) {
                if (item.isFormField()) {
                    this.parameters.put(item.getFieldName(), item.getString("UTF-8"));
                    continue;
                }
                this.parameters.put(item.getFieldName(), item.getName());
                this.fileitems.put(item.getFieldName(), item);
                this.filenames.add(item.getName());
                String filename = this.getFilename(item.getName());
                if (filename == null || "".equals(filename)) continue;
                item.write(new File(this.tempDir + File.separator + filename));
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("exceeds the configured maximum")) {
                int startFirstParen = e.getMessage().indexOf("(") + 1;
                int endFirstParen = e.getMessage().indexOf(")");
                String uploadedSize = e.getMessage().substring(startFirstParen, endFirstParen).trim();
                Long actualSize = Long.parseLong(uploadedSize);
                throw new FileUploadBase.FileSizeLimitExceededException(e.getMessage(), actualSize.longValue(), maxSize);
            }
            throw new IOException(e.getMessage(), e);
        }
    }

    public Enumeration getParameterNames() {
        Set<String> c = this.parameters.keySet();
        return Collections.enumeration(c);
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public String[] getParameterValues(String name) {
        return this.parameters.values().toArray(new String[this.parameters.values().size()]);
    }

    public Map getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration eNum = this.getParameterNames();
        while (eNum.hasMoreElements()) {
            String name = (String)eNum.nextElement();
            map.put(name, this.getParameterValues(name));
        }
        return map;
    }

    public String getFilesystemName(String name) {
        String filename = this.getFilename(this.fileitems.get(name).getName());
        return this.tempDir + File.separator + filename;
    }

    public String getContentType(String name) {
        return this.fileitems.get(name).getContentType();
    }

    public File getFile(String name) {
        FileItem temp = this.fileitems.get(name);
        String tempName = temp.getName();
        String filename = this.getFilename(tempName);
        if ("".equals(filename.trim())) {
            return null;
        }
        return new File(this.tempDir + File.separator + filename);
    }

    public Enumeration<String> getFileParameterNames() {
        Set<String> c = this.fileitems.keySet();
        return Collections.enumeration(c);
    }

    public Enumeration<String> getFileNames() {
        return Collections.enumeration(this.filenames);
    }

    public HttpServletRequest getOriginalRequest() {
        return this.original;
    }

    private String getFilename(String filepath) {
        String filename = filepath.trim();
        int index = filepath.lastIndexOf(File.separator);
        if (index > -1) {
            filename = filepath.substring(index);
        }
        return filename;
    }
}

