/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.servlet.admin.EditCommunitiesServlet;
import org.dspace.app.webui.util.FileUploadRequest;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.FormatIdentifier;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class CollectionWizardServlet
extends DSpaceServlet {
    public static final int INITIAL_QUESTIONS = 1;
    public static final int BASIC_INFO = 2;
    public static final int PERMISSIONS = 3;
    public static final int DEFAULT_ITEM = 4;
    public static final int SUMMARY = 5;
    public static final int PERM_READ = 10;
    public static final int PERM_SUBMIT = 11;
    public static final int PERM_WF1 = 12;
    public static final int PERM_WF2 = 13;
    public static final int PERM_WF3 = 14;
    public static final int PERM_ADMIN = 15;
    private static Logger log = Logger.getLogger(CollectionWizardServlet.class);

    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSPost(context, request, response);
    }

    @Override
    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String contentType = request.getContentType();
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
            this.processBasicInfo(context, request, response);
            return;
        }
        int communityID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"community_id");
        if (communityID > -1) {
            Community c = Community.find((Context)context, (int)communityID);
            if (c == null) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
                JSPManager.showIntegrityError(request, response);
                return;
            }
            Collection newCollection = c.createCollection();
            request.setAttribute("collection", (Object)newCollection);
            if (AuthorizeManager.isAdmin((Context)context)) {
                request.setAttribute("sysadmin_button", (Object)Boolean.TRUE);
            }
            try {
                AuthorizeUtil.authorizeManageAdminGroup((Context)context, (Collection)newCollection);
                request.setAttribute("admin_create_button", (Object)Boolean.TRUE);
            }
            catch (AuthorizeException authex) {
                request.setAttribute("admin_create_button", (Object)Boolean.FALSE);
            }
            try {
                AuthorizeUtil.authorizeManageSubmittersGroup((Context)context, (Collection)newCollection);
                request.setAttribute("submitters_button", (Object)Boolean.TRUE);
            }
            catch (AuthorizeException authex) {
                request.setAttribute("submitters_button", (Object)Boolean.FALSE);
            }
            try {
                AuthorizeUtil.authorizeManageWorkflowsGroup((Context)context, (Collection)newCollection);
                request.setAttribute("workflows_button", (Object)Boolean.TRUE);
            }
            catch (AuthorizeException authex) {
                request.setAttribute("workflows_button", (Object)Boolean.FALSE);
            }
            try {
                AuthorizeUtil.authorizeManageTemplateItem((Context)context, (Collection)newCollection);
                request.setAttribute("template_button", (Object)Boolean.TRUE);
            }
            catch (AuthorizeException authex) {
                request.setAttribute("template_button", (Object)Boolean.FALSE);
            }
            JSPManager.showJSP(request, response, "/dspace-admin/wizard-questions.jsp");
            context.complete();
        } else {
            int collectionID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"collection_id");
            int stage = UIUtil.getIntParameter((HttpServletRequest)request, (String)"stage");
            Collection collection = Collection.find((Context)context, (int)collectionID);
            request.setAttribute("collection", (Object)collection);
            if (collection == null) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
                JSPManager.showIntegrityError(request, response);
                return;
            }
            request.setAttribute("collection.id", (Object)String.valueOf(collection.getID()));
            switch (stage) {
                case 1: {
                    this.processInitialQuestions(context, request, response, collection);
                    break;
                }
                case 3: {
                    this.processPermissions(context, request, response, collection);
                    break;
                }
                case 4: {
                    this.processDefaultItem(context, request, response, collection);
                    break;
                }
                default: {
                    log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
                    JSPManager.showIntegrityError(request, response);
                }
            }
        }
    }

    private void processInitialQuestions(Context context, HttpServletRequest request, HttpServletResponse response, Collection collection) throws SQLException, ServletException, IOException, AuthorizeException {
        if (!UIUtil.getBoolParameter((HttpServletRequest)request, (String)"public_read") && AuthorizeManager.isAdmin((Context)context)) {
            AuthorizeManager.removePoliciesActionFilter((Context)context, (DSpaceObject)collection, (int)10);
            AuthorizeManager.removePoliciesActionFilter((Context)context, (DSpaceObject)collection, (int)9);
        }
        if (UIUtil.getBoolParameter((HttpServletRequest)request, (String)"submitters")) {
            collection.createSubmitters();
        }
        for (int i = 1; i <= 3; ++i) {
            if (!UIUtil.getBoolParameter((HttpServletRequest)request, (String)("workflow" + i))) continue;
            collection.createWorkflowGroup(i);
        }
        if (UIUtil.getBoolParameter((HttpServletRequest)request, (String)"admins")) {
            collection.createAdministrators();
        }
        if (UIUtil.getBoolParameter((HttpServletRequest)request, (String)"default.item")) {
            collection.createTemplateItem();
        }
        collection.setMetadata("name", "");
        collection.update();
        JSPManager.showJSP(request, response, "/dspace-admin/wizard-basicinfo.jsp");
        context.complete();
    }

    private void processPermissions(Context context, HttpServletRequest request, HttpServletResponse response, Collection collection) throws SQLException, ServletException, IOException, AuthorizeException {
        int i;
        int permission = UIUtil.getIntParameter((HttpServletRequest)request, (String)"permission");
        if (UIUtil.getBoolParameter((HttpServletRequest)request, (String)"mitgroup")) {
            Group mitGroup = Group.findByName((Context)context, (String)"MIT Users");
            if (permission == 10) {
                AuthorizeManager.addPolicy((Context)context, (DSpaceObject)collection, (int)10, (Group)mitGroup);
                AuthorizeManager.addPolicy((Context)context, (DSpaceObject)collection, (int)9, (Group)mitGroup);
            } else {
                AuthorizeManager.addPolicy((Context)context, (DSpaceObject)collection, (int)3, (Group)mitGroup);
            }
        }
        Group g = null;
        switch (permission) {
            case 10: {
                g = Group.create((Context)context);
                g.setName("COLLECTION_" + collection.getID() + "_DEFAULT_ITEM_READ");
                AuthorizeManager.addPolicy((Context)context, (DSpaceObject)collection, (int)10, (Group)g);
                AuthorizeManager.addPolicy((Context)context, (DSpaceObject)collection, (int)9, (Group)g);
                break;
            }
            case 11: {
                g = collection.getSubmitters();
                break;
            }
            case 12: {
                g = collection.getWorkflowGroup(1);
                break;
            }
            case 13: {
                g = collection.getWorkflowGroup(2);
                break;
            }
            case 14: {
                g = collection.getWorkflowGroup(3);
                break;
            }
            case 15: {
                g = collection.getAdministrators();
            }
        }
        int[] epersonIds = UIUtil.getIntParameters((HttpServletRequest)request, (String)"eperson_id");
        int[] groupIds = UIUtil.getIntParameters((HttpServletRequest)request, (String)"group_ids");
        if (epersonIds != null) {
            for (i = 0; i < epersonIds.length; ++i) {
                EPerson eperson = EPerson.find((Context)context, (int)epersonIds[i]);
                if (eperson == null) continue;
                g.addMember(eperson);
            }
        }
        if (groupIds != null) {
            for (i = 0; i < groupIds.length; ++i) {
                Group group = Group.find((Context)context, (int)groupIds[i]);
                if (group == null) continue;
                g.addMember(group);
            }
        }
        g.update();
        this.showNextPage(context, request, response, collection, permission);
        context.complete();
    }

    private void processBasicInfo(Context context, HttpServletRequest request, HttpServletResponse response) throws SQLException, ServletException, IOException, AuthorizeException {
        try {
            File temp;
            FileUploadRequest wrapper = new FileUploadRequest(request);
            Collection collection = Collection.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)wrapper, (String)"collection_id"));
            if (collection == null) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)wrapper)));
                JSPManager.showIntegrityError(request, response);
                return;
            }
            collection.setMetadata("name", wrapper.getParameter("name"));
            collection.setMetadata("short_description", wrapper.getParameter("short_description"));
            collection.setMetadata("introductory_text", wrapper.getParameter("introductory_text"));
            collection.setMetadata("copyright_text", wrapper.getParameter("copyright_text"));
            collection.setMetadata("side_bar_text", wrapper.getParameter("side_bar_text"));
            collection.setMetadata("provenance_description", wrapper.getParameter("provenance_description"));
            String license = wrapper.getParameter("license");
            if (!StringUtils.isEmpty((String)license)) {
                collection.setLicense(license);
            }
            if ((temp = wrapper.getFile("file")) != null) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(temp));
                Bitstream logoBS = collection.setLogo((InputStream)is);
                String noPath = wrapper.getFilesystemName("file");
                while (noPath.indexOf(47) > -1) {
                    noPath = noPath.substring(noPath.indexOf(47) + 1);
                }
                while (noPath.indexOf(92) > -1) {
                    noPath = noPath.substring(noPath.indexOf(92) + 1);
                }
                logoBS.setName(noPath);
                logoBS.setSource(wrapper.getFilesystemName("file"));
                BitstreamFormat bf = FormatIdentifier.guessFormat((Context)context, (Bitstream)logoBS);
                logoBS.setFormat(bf);
                AuthorizeManager.addPolicy((Context)context, (DSpaceObject)logoBS, (int)1, (EPerson)context.getCurrentUser());
                logoBS.update();
                if (!temp.delete()) {
                    log.trace((Object)"Unable to delete temporary file");
                }
            }
            collection.update();
            this.showNextPage(context, request, response, collection, 2);
            context.complete();
        }
        catch (FileUploadBase.FileSizeLimitExceededException ex) {
            log.warn((Object)"Upload exceeded upload.max");
            JSPManager.showFileSizeLimitExceededError(request, response, ex.getMessage(), ex.getActualSize(), ex.getPermittedSize());
        }
    }

    private void processDefaultItem(Context context, HttpServletRequest request, HttpServletResponse response, Collection collection) throws SQLException, ServletException, IOException, AuthorizeException {
        Item item = collection.getTemplateItem();
        for (int i = 0; i < 10; ++i) {
            int dcTypeID = UIUtil.getIntParameter((HttpServletRequest)request, (String)("dctype_" + i));
            String value = request.getParameter("value_" + i);
            String lang = request.getParameter("lang_" + i);
            if (dcTypeID == -1 || value == null || value.equals("")) continue;
            MetadataField field = MetadataField.find((Context)context, (int)dcTypeID);
            MetadataSchema schema = MetadataSchema.find((Context)context, (int)field.getSchemaID());
            item.addMetadata(schema.getName(), field.getElement(), field.getQualifier(), lang, value);
        }
        item.update();
        this.showNextPage(context, request, response, collection, 4);
        context.complete();
    }

    private void showNextPage(Context context, HttpServletRequest request, HttpServletResponse response, Collection collection, int stage) throws SQLException, ServletException, IOException, AuthorizeException {
        request.setAttribute("collection", (Object)collection);
        if (Group.findByName((Context)context, (String)"MIT Users") != null) {
            request.setAttribute("mitgroup", (Object)Boolean.TRUE);
        }
        log.debug((Object)LogManager.getHeader((Context)context, (String)"nextpage", (String)("stage=" + stage)));
        switch (stage) {
            case 2: {
                List anonReadPols = AuthorizeManager.getPoliciesActionFilter((Context)context, (DSpaceObject)collection, (int)10);
                if (anonReadPols.size() == 0) {
                    request.setAttribute("permission", (Object)10);
                    JSPManager.showJSP(request, response, "/dspace-admin/wizard-permissions.jsp");
                    break;
                }
            }
            case 10: {
                if (collection.getSubmitters() != null) {
                    request.setAttribute("permission", (Object)11);
                    JSPManager.showJSP(request, response, "/dspace-admin/wizard-permissions.jsp");
                    break;
                }
            }
            case 11: {
                if (collection.getWorkflowGroup(1) != null) {
                    request.setAttribute("permission", (Object)12);
                    JSPManager.showJSP(request, response, "/dspace-admin/wizard-permissions.jsp");
                    break;
                }
            }
            case 12: {
                if (collection.getWorkflowGroup(2) != null) {
                    request.setAttribute("permission", (Object)13);
                    JSPManager.showJSP(request, response, "/dspace-admin/wizard-permissions.jsp");
                    break;
                }
            }
            case 13: {
                if (collection.getWorkflowGroup(3) != null) {
                    request.setAttribute("permission", (Object)14);
                    JSPManager.showJSP(request, response, "/dspace-admin/wizard-permissions.jsp");
                    break;
                }
            }
            case 14: {
                if (collection.getAdministrators() != null) {
                    request.setAttribute("permission", (Object)15);
                    JSPManager.showJSP(request, response, "/dspace-admin/wizard-permissions.jsp");
                    break;
                }
            }
            case 15: {
                if (collection.getTemplateItem() != null) {
                    MetadataField[] types = MetadataField.findAll((Context)context);
                    request.setAttribute("dctypes", (Object)types);
                    JSPManager.showJSP(request, response, "/dspace-admin/wizard-default-item.jsp");
                    break;
                }
            }
            case 4: {
                if (collection != null) {
                    Community[] communities = collection.getCommunities();
                    request.setAttribute("community", (Object)communities[0]);
                    EditCommunitiesServlet.storeAuthorizeAttributeCollectionEdit(context, request, collection);
                }
                JSPManager.showJSP(request, response, "/tools/edit-collection.jsp");
            }
        }
    }
}

