/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import com.sun.mail.smtp.SMTPAddressFailedException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.internet.AddressException;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.servlet.EditProfileServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.AccountManager;
import org.dspace.eperson.EPerson;

public class RegisterServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(RegisterServlet.class);
    public static final int ENTER_EMAIL_PAGE = 1;
    public static final int PERSONAL_INFO_PAGE = 2;
    public static final int NEW_PASSWORD_PAGE = 3;
    private boolean registering;
    private boolean ldap_enabled;

    public void init() {
        this.registering = this.getInitParameter("register").equalsIgnoreCase("true");
        this.ldap_enabled = ConfigurationManager.getBooleanProperty((String)"ldap.enable");
    }

    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String token = request.getParameter("token");
        if (token == null) {
            if (this.registering) {
                if (this.ldap_enabled) {
                    JSPManager.showJSP(request, response, "/register/new-ldap-user.jsp");
                }
                JSPManager.showJSP(request, response, "/register/new-user.jsp");
            } else {
                JSPManager.showJSP(request, response, "/register/forgot-password.jsp");
            }
        } else {
            String email = AccountManager.getEmail((Context)context, (String)token);
            EPerson eperson = null;
            if (email != null) {
                eperson = EPerson.findByEmail((Context)context, (String)email);
            }
            request.setAttribute("eperson", (Object)eperson);
            request.setAttribute("token", (Object)token);
            if (this.registering && email != null) {
                boolean setPassword = AuthenticationManager.allowSetPassword((Context)context, (HttpServletRequest)request, (String)email);
                request.setAttribute("set.password", (Object)setPassword);
                JSPManager.showJSP(request, response, "/register/registration-form.jsp");
            } else if (!this.registering && eperson != null) {
                JSPManager.showJSP(request, response, "/register/new-password.jsp");
            } else {
                JSPManager.showJSP(request, response, "/register/invalid-token.jsp");
                return;
            }
        }
    }

    @Override
    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        int step = UIUtil.getIntParameter((HttpServletRequest)request, (String)"step");
        switch (step) {
            case 1: {
                this.processEnterEmail(context, request, response);
                break;
            }
            case 2: {
                this.processPersonalInfo(context, request, response);
                break;
            }
            case 3: {
                this.processNewPassword(context, request, response);
                break;
            }
            default: {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
                JSPManager.showIntegrityError(request, response);
            }
        }
    }

    private void processEnterEmail(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        block24: {
            String email = request.getParameter("email");
            email = email == null || email.length() > 64 ? "" : email.toLowerCase().trim();
            String netid = request.getParameter("netid");
            String password = request.getParameter("password");
            EPerson eperson = EPerson.findByEmail((Context)context, (String)email);
            EPerson eperson2 = null;
            if (netid != null) {
                eperson2 = EPerson.findByNetid((Context)context, (String)netid.toLowerCase());
            }
            try {
                if (this.registering) {
                    if (eperson != null && eperson.canLogIn() || eperson2 != null && eperson2.canLogIn()) {
                        log.info((Object)LogManager.getHeader((Context)context, (String)"already_registered", (String)("email=" + email)));
                        JSPManager.showJSP(request, response, "/register/already-registered.jsp");
                        break block24;
                    }
                    boolean canRegister = AuthenticationManager.canSelfRegister((Context)context, (HttpServletRequest)request, (String)email);
                    if (canRegister) {
                        if (!this.ldap_enabled || netid == null || netid.trim().equals("")) {
                            log.info((Object)LogManager.getHeader((Context)context, (String)"sendtoken_register", (String)("email=" + email)));
                            try {
                                AccountManager.sendRegistrationInfo((Context)context, (String)email);
                            }
                            catch (SendFailedException e) {
                                if (e.getNextException() instanceof SMTPAddressFailedException) {
                                    log.info((Object)LogManager.getHeader((Context)context, (String)"invalid_email", (String)("email=" + email)));
                                    request.setAttribute("retry", (Object)Boolean.TRUE);
                                    JSPManager.showJSP(request, response, "/register/new-user.jsp");
                                    return;
                                }
                                throw e;
                            }
                            JSPManager.showJSP(request, response, "/register/registration-sent.jsp");
                            context.complete();
                            break block24;
                        }
                        if (password != null && !password.equals("")) {
                            String ldap_provider_url = ConfigurationManager.getProperty((String)"ldap.provider_url");
                            String ldap_id_field = ConfigurationManager.getProperty((String)"ldap.id_field");
                            String ldap_search_context = ConfigurationManager.getProperty((String)"ldap.search_context");
                            Hashtable<String, String> env = new Hashtable<String, String>(11);
                            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                            env.put("java.naming.provider.url", ldap_provider_url);
                            env.put("java.naming.security.authentication", "simple");
                            env.put("java.naming.security.principal", ldap_id_field + "=" + netid + "," + ldap_search_context);
                            env.put("java.naming.security.credentials", password);
                            try {
                                InitialDirContext ctx = new InitialDirContext(env);
                                ctx.close();
                            }
                            catch (NamingException e) {
                                log.info((Object)LogManager.getHeader((Context)context, (String)"failed_login", (String)("netid=" + netid + e)));
                                JSPManager.showJSP(request, response, "/login/ldap-incorrect.jsp");
                                return;
                            }
                        }
                        JSPManager.showJSP(request, response, "/register/registration-form.jsp");
                        break block24;
                    }
                    JSPManager.showJSP(request, response, "/register/cannot-register.jsp");
                    break block24;
                }
                if (eperson == null) {
                    log.info((Object)LogManager.getHeader((Context)context, (String)"unknown_email", (String)("email=" + email)));
                    request.setAttribute("retry", (Object)Boolean.TRUE);
                    JSPManager.showJSP(request, response, "/register/forgot-password.jsp");
                } else if (!eperson.canLogIn()) {
                    log.info((Object)LogManager.getHeader((Context)context, (String)"unregistered_forgot_password", (String)("email=" + email)));
                    JSPManager.showJSP(request, response, "/register/inactive-account.jsp");
                } else if (eperson.getRequireCertificate() && !this.registering) {
                    log.info((Object)LogManager.getHeader((Context)context, (String)"certificate_user_forgot_password", (String)("email=" + email)));
                    JSPManager.showJSP(request, response, "/error/require-certificate.jsp");
                } else {
                    log.info((Object)LogManager.getHeader((Context)context, (String)"sendtoken_forgotpw", (String)("email=" + email)));
                    AccountManager.sendForgotPasswordInfo((Context)context, (String)email);
                    JSPManager.showJSP(request, response, "/register/password-token-sent.jsp");
                    context.complete();
                }
            }
            catch (AddressException ae) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"bad_email", (String)("email=" + email)));
                request.setAttribute("retry", (Object)Boolean.TRUE);
                if (this.registering) {
                    if (this.ldap_enabled) {
                        JSPManager.showJSP(request, response, "/register/new-ldap-user.jsp");
                    } else {
                        JSPManager.showJSP(request, response, "/register/new-user.jsp");
                    }
                } else {
                    JSPManager.showJSP(request, response, "/register/forgot-password.jsp");
                }
            }
            catch (MessagingException me) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"error_emailing", (String)("email=" + email)), (Throwable)me);
                JSPManager.showInternalError(request, response);
            }
        }
    }

    private void processPersonalInfo(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String token = request.getParameter("token");
        String email = AccountManager.getEmail((Context)context, (String)token);
        String netid = request.getParameter("netid");
        if (netid != null && email == null) {
            email = request.getParameter("email");
        }
        if (email == null && netid == null) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"invalid_token", (String)("token=" + token)));
            JSPManager.showJSP(request, response, "/register/invalid-token.jsp");
            return;
        }
        EPerson eperson = null;
        if (email != null) {
            eperson = EPerson.findByEmail((Context)context, (String)email);
        }
        EPerson eperson2 = null;
        if (netid != null) {
            eperson2 = EPerson.findByNetid((Context)context, (String)netid.toLowerCase());
        }
        if (eperson2 != null) {
            eperson = eperson2;
        }
        if (eperson == null) {
            context.setIgnoreAuthorization(true);
            eperson = EPerson.create((Context)context);
            eperson.setEmail(email);
            if (netid != null) {
                eperson.setNetid(netid.toLowerCase());
            }
            eperson.update();
            context.setIgnoreAuthorization(false);
        }
        context.setCurrentUser(eperson);
        boolean infoOK = EditProfileServlet.updateUserProfile(eperson, request);
        eperson.setCanLogIn(true);
        eperson.setSelfRegistered(true);
        AuthenticationManager.initEPerson((Context)context, (HttpServletRequest)request, (EPerson)eperson);
        boolean passwordOK = true;
        if (!eperson.getRequireCertificate() && netid == null && AuthenticationManager.allowSetPassword((Context)context, (HttpServletRequest)request, (String)eperson.getEmail())) {
            passwordOK = EditProfileServlet.confirmAndSetPassword(eperson, request);
        }
        if (infoOK && passwordOK) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"usedtoken_register", (String)("email=" + eperson.getEmail())));
            if (token != null) {
                AccountManager.deleteToken((Context)context, (String)token);
            }
            eperson.update();
            request.setAttribute("eperson", (Object)eperson);
            JSPManager.showJSP(request, response, "/register/registered.jsp");
            context.complete();
        } else {
            request.setAttribute("token", (Object)token);
            request.setAttribute("eperson", (Object)eperson);
            request.setAttribute("netid", (Object)netid);
            request.setAttribute("missing.fields", (Object)(!infoOK ? 1 : 0));
            request.setAttribute("password.problem", (Object)(!passwordOK ? 1 : 0));
            boolean setPassword = AuthenticationManager.allowSetPassword((Context)context, (HttpServletRequest)request, (String)email);
            request.setAttribute("set.password", (Object)setPassword);
            JSPManager.showJSP(request, response, "/register/registration-form.jsp");
            context.abort();
        }
    }

    private void processNewPassword(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String token = request.getParameter("token");
        EPerson eperson = AccountManager.getEPerson((Context)context, (String)token);
        if (eperson == null) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"invalid_token", (String)("token=" + token)));
            JSPManager.showJSP(request, response, "/register/invalid-token.jsp");
            return;
        }
        context.setCurrentUser(eperson);
        boolean passwordOK = EditProfileServlet.confirmAndSetPassword(eperson, request);
        if (passwordOK) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"usedtoken_forgotpw", (String)("email=" + eperson.getEmail())));
            eperson.update();
            AccountManager.deleteToken((Context)context, (String)token);
            JSPManager.showJSP(request, response, "/register/password-changed.jsp");
            context.complete();
        } else {
            request.setAttribute("password.problem", (Object)Boolean.TRUE);
            request.setAttribute("token", (Object)token);
            request.setAttribute("eperson", (Object)eperson);
            JSPManager.showJSP(request, response, "/register/new-password.jsp");
        }
    }
}

