/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.dspace.app.util.OpenSearch;
import org.dspace.app.util.SyndicationFeed;
import org.dspace.app.util.Util;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.handle.HandleManager;
import org.dspace.search.DSQuery;
import org.dspace.search.QueryArgs;
import org.dspace.search.QueryResults;
import org.dspace.sort.SortOption;
import org.w3c.dom.Document;

public class OpenSearchServlet
extends DSpaceServlet {
    private static final long serialVersionUID = 1L;
    private static String msgKey = "org.dspace.app.webui.servlet.FeedServlet";
    private static Logger log = Logger.getLogger(OpenSearchServlet.class);
    private Map<String, Map<String, String>> localeLabels = null;

    public void init() {
        this.localeLabels = new HashMap<String, Map<String, String>>();
    }

    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String path;
        String scope = request.getParameter("scope");
        if (scope != null && "".equals(scope)) {
            scope = null;
        }
        if ((path = request.getPathInfo()) != null && path.endsWith("description.xml")) {
            String svcDescrip = OpenSearch.getDescription((String)scope);
            response.setContentType(OpenSearch.getContentType((String)"opensearchdescription"));
            response.setContentLength(svcDescrip.length());
            response.getWriter().write(svcDescrip);
            return;
        }
        String format = request.getParameter("format");
        if (format == null || "".equals(format)) {
            format = "atom";
        }
        if (!OpenSearch.getFormats().contains(format)) {
            response.sendError(400);
            return;
        }
        String query = request.getParameter("query");
        int start = Util.getIntParameter((HttpServletRequest)request, (String)"start");
        int rpp = Util.getIntParameter((HttpServletRequest)request, (String)"rpp");
        int sort = Util.getIntParameter((HttpServletRequest)request, (String)"sort_by");
        String order = request.getParameter("order");
        String sortOrder = order == null || order.length() == 0 || order.toLowerCase().startsWith("asc") ? "ASC" : "DESC";
        QueryArgs qArgs = new QueryArgs();
        if (start < 0) {
            start = 0;
        }
        qArgs.setStart(start);
        if (rpp > 0) {
            qArgs.setPageSize(rpp);
        }
        qArgs.setSortOrder(sortOrder);
        if (sort > 0) {
            try {
                qArgs.setSortOption(SortOption.getSortOption((int)sort));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        qArgs.setSortOrder(sortOrder);
        if (query == null) {
            query = "";
        }
        DSpaceObject container = scope != null ? HandleManager.resolveToObject((Context)context, (String)scope) : null;
        String logInfo = "";
        qArgs.setQuery(query);
        QueryResults qResults = null;
        if (container == null) {
            qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs);
        } else if (container instanceof Collection) {
            logInfo = "collection_id=" + container.getID() + ",";
            qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs, (Collection)((Collection)container));
        } else if (container instanceof Community) {
            logInfo = "community_id=" + container.getID() + ",";
            qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs, (Community)((Community)container));
        } else {
            throw new IllegalStateException("Invalid container for search context");
        }
        DSpaceObject[] results = new DSpaceObject[qResults.getHitHandles().size()];
        for (int i = 0; i < qResults.getHitHandles().size(); ++i) {
            String myHandle = (String)qResults.getHitHandles().get(i);
            DSpaceObject dso = HandleManager.resolveToObject((Context)context, (String)myHandle);
            if (dso == null) {
                throw new SQLException("Query \"" + query + "\" returned unresolvable handle: " + myHandle);
            }
            results[i] = dso;
        }
        log.info((Object)LogManager.getHeader((Context)context, (String)"search", (String)(logInfo + "query=\"" + query + "\",results=(" + results.length + ")")));
        Map<String, String> labelMap = this.getLabels(request);
        Document resultsDoc = OpenSearch.getResultsDoc((String)format, (String)query, (QueryResults)qResults, (DSpaceObject)container, (DSpaceObject[])results, labelMap);
        try {
            Transformer xf = TransformerFactory.newInstance().newTransformer();
            response.setContentType(OpenSearch.getContentType((String)format));
            xf.transform(new DOMSource(resultsDoc), new StreamResult(response.getWriter()));
        }
        catch (TransformerException e) {
            log.error((Object)e);
            throw new ServletException(e.toString(), (Throwable)e);
        }
    }

    private Map<String, String> getLabels(HttpServletRequest request) {
        Locale locale = request.getLocale();
        Map<String, String> labelMap = this.localeLabels.get(locale.toString());
        if (labelMap == null) {
            labelMap = this.getLocaleLabels(locale);
            this.localeLabels.put(locale.toString(), labelMap);
        }
        return labelMap;
    }

    private Map<String, String> getLocaleLabels(Locale locale) {
        HashMap<String, String> labelMap = new HashMap<String, String>();
        ResourceBundle labels = ResourceBundle.getBundle("Messages", locale);
        labelMap.put("notitle", labels.getString(msgKey + ".notitle"));
        labelMap.put("logo.title", labels.getString(msgKey + ".logo.title"));
        labelMap.put("general-feed.description", labels.getString(msgKey + ".general-feed.description"));
        labelMap.put("ui.type", "jspui");
        for (String selector : SyndicationFeed.getDescriptionSelectors()) {
            labelMap.put("metadata." + selector, labels.getString("metadata." + selector));
        }
        return labelMap;
    }
}

