/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.Date;
import java.util.Locale;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.validator.EmailValidator;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;

public class FeedbackServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(FeedbackServlet.class);

    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String fromPage = request.getHeader("Referer");
        String host = ConfigurationManager.getProperty((String)"dspace.hostname");
        String basicHost = "";
        if (host.equals("localhost") || host.equals("127.0.0.1") || host.equals(InetAddress.getLocalHost().getHostAddress())) {
            basicHost = host;
        } else {
            int lastDot = host.lastIndexOf(46);
            basicHost = host.substring(host.substring(0, lastDot).lastIndexOf("."));
        }
        if (fromPage == null || fromPage.indexOf(basicHost) == -1) {
            throw new AuthorizeException();
        }
        String formEmail = request.getParameter("email");
        String userAgent = request.getHeader("User-Agent");
        String sessionID = request.getSession().getId();
        EPerson currentUser = context.getCurrentUser();
        String authEmail = null;
        if (currentUser != null) {
            authEmail = currentUser.getEmail();
        }
        if (request.getParameter("submit") != null) {
            EmailValidator ev = EmailValidator.getInstance();
            String feedback = request.getParameter("feedback");
            if (formEmail == null || formEmail.equals("") || feedback == null || feedback.equals("") || !ev.isValid(formEmail)) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"show_feedback_form", (String)"problem=true"));
                request.setAttribute("feedback.problem", (Object)Boolean.TRUE);
                JSPManager.showJSP(request, response, "/feedback/form.jsp");
                return;
            }
            try {
                Email email = ConfigurationManager.getEmail((String)I18nUtil.getEmailFilename((Locale)context.getCurrentLocale(), (String)"feedback"));
                email.addRecipient(ConfigurationManager.getProperty((String)"feedback.recipient"));
                email.addArgument((Object)new Date());
                email.addArgument((Object)formEmail);
                email.addArgument((Object)authEmail);
                email.addArgument((Object)fromPage);
                email.addArgument((Object)userAgent);
                email.addArgument((Object)sessionID);
                email.addArgument((Object)feedback);
                email.setReplyTo(formEmail);
                email.send();
                log.info((Object)LogManager.getHeader((Context)context, (String)"sent_feedback", (String)("from=" + formEmail)));
                JSPManager.showJSP(request, response, "/feedback/acknowledge.jsp");
            }
            catch (MessagingException me) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"error_mailing_feedback", (String)""), (Throwable)me);
                JSPManager.showInternalError(request, response);
            }
        } else {
            log.info((Object)LogManager.getHeader((Context)context, (String)"show_feedback_form", (String)"problem=false"));
            request.setAttribute("authenticated.email", (Object)authEmail);
            JSPManager.showJSP(request, response, "/feedback/form.jsp");
        }
    }

    @Override
    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSGet(context, request, response);
    }
}

