/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflow;

import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.dspace.workflow.FlowStep;
import org.dspace.workflow.FlowstepType;
import org.dspace.workflow.MappingType;
import org.dspace.workflow.NotifyType;
import org.dspace.workflow.Task;
import org.dspace.workflow.TaskSet;
import org.dspace.workflow.TaskType;
import org.dspace.workflow.WorkflowCuration;
import org.dspace.workflow.WorkflowType;
import org.xml.sax.SAXException;

public class CurationTaskConfig {
    public static final String DEFAULT_TASKSET_NAME = "default";
    private final Map<String, TaskSet> collectionTasksetMap;

    public CurationTaskConfig(InputStream configurationDocument) throws JAXBException, SAXException, IOException {
        this.collectionTasksetMap = this.loadTaskConfig(configurationDocument);
    }

    @NotNull
    public TaskSet findTaskSet(@NotNull String setName) {
        if (this.collectionTasksetMap.containsKey(setName)) {
            return this.collectionTasksetMap.get(setName);
        }
        if (this.collectionTasksetMap.containsKey(DEFAULT_TASKSET_NAME)) {
            return this.collectionTasksetMap.get(DEFAULT_TASKSET_NAME);
        }
        return new TaskSet("", Collections.EMPTY_LIST);
    }

    public boolean containsKey(@NotNull String name) {
        return this.collectionTasksetMap.containsKey(name);
    }

    private Map<String, TaskSet> loadTaskConfig(InputStream configuration) throws JAXBException, SAXException, IOException {
        WorkflowCuration workflows;
        HashMap<String, TaskSet> workflowConfiguration = new HashMap<String, TaskSet>();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{WorkflowCuration.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(CurationTaskConfig.class.getResource("workflow-curation.xsd"));
        unmarshaller.setSchema(schema);
        try (InputStreamReader configurationReader = new InputStreamReader(configuration, StandardCharsets.UTF_8);){
            workflows = (WorkflowCuration)unmarshaller.unmarshal((Reader)configurationReader);
        }
        for (MappingType mapping : workflows.getTasksetMap().getMapping()) {
            ArrayList<FlowStep> flowsteps = new ArrayList<FlowStep>(mapping.getTaskset().getFlowstep().size());
            for (FlowstepType step : mapping.getTaskset().getFlowstep()) {
                FlowStep flowstep = new FlowStep(step.getName(), step.getQueue());
                for (TaskType task : step.getTask()) {
                    Task stepTask = new Task(task.getName());
                    for (Object thing : task.getWorkflowOrNotify()) {
                        if (thing instanceof WorkflowType) {
                            WorkflowType action = (WorkflowType)thing;
                            stepTask.addPower(action.getValue().value());
                            continue;
                        }
                        if (!(thing instanceof NotifyType)) continue;
                        NotifyType notify = (NotifyType)thing;
                        stepTask.addContact(notify.getOn().value(), notify.getValue());
                    }
                    flowstep.addTask(stepTask);
                }
                flowsteps.add(flowstep);
            }
            workflowConfiguration.put(mapping.getCollectionHandle(), new TaskSet(mapping.getTaskset().getName(), flowsteps));
        }
        return workflowConfiguration;
    }
}

