/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.bitstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.core.Utils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.storage.bitstore.BaseBitStoreService;
import org.dspace.storage.bitstore.factory.StorageServiceFactory;
import org.dspace.storage.bitstore.service.BitstreamStorageService;
import org.dspace.util.FunctionalUtils;
import org.springframework.beans.factory.annotation.Autowired;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3CrtAsyncClientBuilder;
import software.amazon.awssdk.services.s3.model.ChecksumAlgorithm;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;

public class S3BitStoreService
extends BaseBitStoreService {
    protected static final String DEFAULT_BUCKET_PREFIX = "dspace-asset-";
    protected final String REGISTERED_FLAG = "-R";
    private static final Logger log = LogManager.getLogger(S3BitStoreService.class);
    static final String CSA = "MD5";
    private boolean enabled = false;
    private String endpoint = null;
    private String awsAccessKey;
    private String awsSecretKey;
    private String awsRegionName;
    private boolean useRelativePath;
    private double targetThroughputGbps = 10.0;
    private long minPartSizeBytes = 0x800000L;
    private ChecksumAlgorithm s3ChecksumAlgorithm = ChecksumAlgorithm.CRC32;
    private Integer maxConcurrency = null;
    private String bucketName = null;
    private String subfolder = null;
    private S3AsyncClient s3AsyncClient = null;
    private static final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    protected static Supplier<S3AsyncClient> amazonClientBuilderBy(Region region, AwsCredentialsProvider credentialsProvider, String endpoint, double targetThroughput, long minPartSize, Integer maxConcurrency) {
        return () -> {
            S3CrtAsyncClientBuilder crtBuilder = S3AsyncClient.crtBuilder();
            if (credentialsProvider != null) {
                crtBuilder.credentialsProvider(credentialsProvider);
            }
            if (region != null) {
                crtBuilder.region(region);
            }
            if (maxConcurrency != null) {
                crtBuilder.maxConcurrency(maxConcurrency);
            }
            if (StringUtils.isNotBlank((CharSequence)endpoint)) {
                crtBuilder.endpointOverride(URI.create(endpoint));
                crtBuilder.forcePathStyle(Boolean.valueOf(true));
            }
            return crtBuilder.targetThroughputInGbps(Double.valueOf(targetThroughput)).minimumPartSizeInBytes(Long.valueOf(minPartSize)).build();
        };
    }

    public S3BitStoreService() {
    }

    protected S3BitStoreService(S3AsyncClient s3AsyncClient) {
        this.s3AsyncClient = s3AsyncClient;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void init() throws IOException {
        if (this.isInitialized() || !this.isEnabled()) {
            return;
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)this.getAwsAccessKey()) && StringUtils.isNotBlank((CharSequence)this.getAwsSecretKey())) {
                log.warn("Use local defined S3 credentials");
                Region region = Region.US_EAST_1;
                if (StringUtils.isNotBlank((CharSequence)this.awsRegionName)) {
                    try {
                        region = Region.of((String)this.awsRegionName);
                    }
                    catch (IllegalArgumentException e) {
                        log.warn("Invalid aws_region: " + this.awsRegionName);
                    }
                }
                this.s3AsyncClient = FunctionalUtils.getDefaultOrBuild(this.s3AsyncClient, S3BitStoreService.amazonClientBuilderBy(region, (AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.getAwsAccessKey(), (String)this.getAwsSecretKey())), this.endpoint, this.targetThroughputGbps, this.minPartSizeBytes, this.maxConcurrency));
                log.warn("S3 Region set to: " + region.id());
            } else {
                log.info("Using a IAM role or aws environment credentials");
                this.s3AsyncClient = FunctionalUtils.getDefaultOrBuild(this.s3AsyncClient, S3BitStoreService.amazonClientBuilderBy(null, null, this.endpoint, this.targetThroughputGbps, this.minPartSizeBytes, this.maxConcurrency));
            }
            if (StringUtils.isEmpty((CharSequence)this.bucketName)) {
                String hostname = Utils.getHostName(configurationService.getProperty("dspace.ui.url"));
                this.bucketName = DEFAULT_BUCKET_PREFIX + hostname;
                log.warn("S3 BucketName is not configured, setting default: " + this.bucketName);
            }
            if (!this.doesBucketExist(this.bucketName)) {
                this.s3AsyncClient.createBucket(r -> r.bucket(this.bucketName)).join();
                log.info("Creating new S3 Bucket: " + this.bucketName);
            }
            this.initialized = true;
            log.info("AWS S3 Assetstore ready to go! bucket:" + this.bucketName);
        }
        catch (Exception e) {
            this.initialized = false;
            log.error("Can't initialize this store!", (Throwable)e);
        }
    }

    public boolean doesBucketExist(String bucketName) {
        try {
            this.s3AsyncClient.headBucket(r -> r.bucket(bucketName)).join();
            return true;
        }
        catch (CompletionException ce) {
            if (!(ce.getCause() instanceof NoSuchBucketException)) {
                log.error("headBucket(" + bucketName + ")", ce.getCause());
            }
            return false;
        }
    }

    @Override
    public String generateId() {
        return Utils.generateKey();
    }

    @Override
    public InputStream get(Bitstream bitstream) throws IOException {
        String key = this.getFullKey(bitstream.getInternalId());
        if (this.isRegisteredBitstream(key)) {
            key = key.substring("-R".length());
        }
        String objectKey = key;
        try {
            return (InputStream)this.s3AsyncClient.getObject(r -> r.bucket(this.bucketName).key(objectKey), AsyncResponseTransformer.toBlockingInputStream()).join();
        }
        catch (CompletionException e) {
            throw new IOException(e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Bitstream bitstream, InputStream in) throws IOException {
        String key = this.getFullKey(bitstream.getInternalId());
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try (DigestInputStream dis = new DigestInputStream(in, MessageDigest.getInstance(CSA));){
            AsyncRequestBody body = AsyncRequestBody.fromInputStream((InputStream)dis, null, (ExecutorService)executor);
            this.s3AsyncClient.putObject(b -> b.bucket(this.bucketName).key(key).checksumAlgorithm(this.s3ChecksumAlgorithm), body).join();
            bitstream.setSizeBytes(((HeadObjectResponse)this.s3AsyncClient.headObject(r -> r.bucket(this.bucketName).key(key)).join()).contentLength());
            bitstream.setChecksum(Utils.toHex(dis.getMessageDigest().digest()));
            bitstream.setChecksumAlgorithm(CSA);
        }
        catch (CompletionException e) {
            log.error("put(" + bitstream.getInternalId() + ", is)", e.getCause());
            throw new IOException(e.getCause());
        }
        catch (IOException e) {
            log.error("put(" + bitstream.getInternalId() + ", is)", (Throwable)e);
            throw new IOException(e);
        }
        catch (NoSuchAlgorithmException nsae) {
            log.warn("Caught NoSuchAlgorithmException", (Throwable)nsae);
        }
        finally {
            executor.shutdown();
            in.close();
        }
    }

    @Override
    public Map<String, Object> about(Bitstream bitstream, List<String> attrs) throws IOException {
        String key = this.getFullKey(bitstream.getInternalId());
        if (this.isRegisteredBitstream(key)) {
            key = key.substring("-R".length());
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        try {
            String objectKey = key;
            HeadObjectResponse response = (HeadObjectResponse)this.s3AsyncClient.headObject(r -> r.bucket(this.bucketName).key(objectKey)).join();
            this.putValueIfExistsKey(attrs, metadata, "size_bytes", response.contentLength());
            this.putValueIfExistsKey(attrs, metadata, "modified", String.valueOf(response.lastModified().toEpochMilli()));
            this.putValueIfExistsKey(attrs, metadata, "checksum_algorithm", CSA);
            if (attrs.contains("checksum")) {
                try (InputStream in = this.get(bitstream);
                     DigestInputStream dis = new DigestInputStream(in, MessageDigest.getInstance(CSA));){
                    Utils.copy(dis, (OutputStream)NullOutputStream.INSTANCE);
                    byte[] md5Digest = dis.getMessageDigest().digest();
                    metadata.put("checksum", Utils.toHex(md5Digest));
                }
                catch (NoSuchAlgorithmException nsae) {
                    log.warn("Caught NoSuchAlgorithmException", (Throwable)nsae);
                }
            }
            return metadata;
        }
        catch (CompletionException e) {
            AwsServiceException awsEx;
            Throwable throwable = e.getCause();
            if (throwable instanceof AwsServiceException && (awsEx = (AwsServiceException)throwable).statusCode() == 404) {
                return metadata;
            }
            log.error("about(" + key + ", attrs)", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public void remove(Bitstream bitstream) throws IOException {
        String key = this.getFullKey(bitstream.getInternalId());
        try {
            this.s3AsyncClient.deleteObject(r -> r.bucket(this.bucketName).key(key)).join();
        }
        catch (CompletionException e) {
            log.error("remove(" + key + ")", e.getCause());
            throw new IOException(e.getCause());
        }
    }

    public String getFullKey(String id) {
        StringBuilder bufFilename = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)this.subfolder)) {
            bufFilename.append(this.subfolder);
            this.appendSeparator(bufFilename);
        }
        if (this.useRelativePath) {
            bufFilename.append(this.getRelativePath(id));
        } else {
            bufFilename.append(id);
        }
        if (log.isDebugEnabled()) {
            log.debug("S3 filepath for " + id + " is " + bufFilename.toString());
        }
        return bufFilename.toString();
    }

    public String getRelativePath(String sInternalId) {
        BitstreamStorageService bitstreamStorageService = StorageServiceFactory.getInstance().getBitstreamStorageService();
        String sIntermediatePath = "";
        if (bitstreamStorageService.isRegisteredBitstream(sInternalId)) {
            sInternalId = sInternalId.substring("-R".length());
        } else {
            sInternalId = this.sanitizeIdentifier(sInternalId);
            sIntermediatePath = this.getIntermediatePath(sInternalId);
        }
        return sIntermediatePath + sInternalId;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    @Autowired(required=true)
    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    @Autowired(required=true)
    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    public String getAwsRegionName() {
        return this.awsRegionName;
    }

    public void setAwsRegionName(String awsRegionName) {
        this.awsRegionName = awsRegionName;
    }

    @Autowired(required=true)
    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getSubfolder() {
        return this.subfolder;
    }

    public void setSubfolder(String subfolder) {
        this.subfolder = subfolder;
    }

    public boolean isUseRelativePath() {
        return this.useRelativePath;
    }

    public void setUseRelativePath(boolean useRelativePath) {
        this.useRelativePath = useRelativePath;
    }

    public double getTargetThroughputGbps() {
        return this.targetThroughputGbps;
    }

    public void setTargetThroughputGbps(double targetThroughputGbps) {
        this.targetThroughputGbps = targetThroughputGbps;
    }

    public long getMinPartSizeBytes() {
        return this.minPartSizeBytes;
    }

    public void setMinPartSizeBytes(long minPartSizeBytes) {
        this.minPartSizeBytes = minPartSizeBytes;
    }

    public ChecksumAlgorithm getS3ChecksumAlgorithm() {
        return this.s3ChecksumAlgorithm;
    }

    public void setS3ChecksumAlgorithm(ChecksumAlgorithm s3ChecksumAlgorithm) {
        this.s3ChecksumAlgorithm = s3ChecksumAlgorithm;
    }

    public Integer getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public void setMaxConcurrency(Integer maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public static void main(String[] args) throws Exception {
        CommandLine command;
        Options options = new Options();
        Option option = Option.builder((String)"a").desc("access key").hasArg().required().build();
        options.addOption(option);
        option = Option.builder((String)"s").desc("secret key").hasArg().required().build();
        options.addOption(option);
        option = Option.builder((String)"f").desc("asset file name").hasArg().required().build();
        options.addOption(option);
        DefaultParser parser = new DefaultParser();
        try {
            command = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            new HelpFormatter().printHelp(S3BitStoreService.class.getSimpleName() + "options", options);
            return;
        }
        String accessKey = command.getOptionValue("a");
        String secretKey = command.getOptionValue("s");
        S3BitStoreService store = new S3BitStoreService();
        StaticCredentialsProvider credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey));
        store.s3AsyncClient = (S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider)).region(Region.US_EAST_1)).build();
        String hostname = Utils.getHostName(configurationService.getProperty("dspace.ui.url"));
        store.bucketName = DEFAULT_BUCKET_PREFIX + hostname + ".s3test";
        store.s3AsyncClient.createBucket(r -> r.bucket(store.bucketName)).join();
    }

    public boolean isRegisteredBitstream(String internalId) {
        return internalId.startsWith("-R");
    }
}

