/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.profile;

import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.util.UUIDUtils;
import org.springframework.util.Assert;

public class ResearcherProfile {
    private final Item item;
    private final MetadataValue dspaceObjectOwner;

    public ResearcherProfile(Item item) {
        Assert.notNull((Object)item, (String)"A researcher profile requires an item");
        this.item = item;
        this.dspaceObjectOwner = this.getDspaceObjectOwnerMetadata(item);
    }

    public UUID getId() {
        return UUIDUtils.fromString(this.dspaceObjectOwner.getAuthority());
    }

    public boolean isVisible() {
        return this.item.getResourcePolicies().stream().filter(policy -> policy.getGroup() != null).anyMatch(policy -> 0 == policy.getAction() && "Anonymous".equals(policy.getGroup().getName()));
    }

    public Item getItem() {
        return this.item;
    }

    public Optional<String> getOrcid() {
        return this.getMetadataValue(this.item, "person.identifier.orcid").map(metadataValue -> metadataValue.getValue());
    }

    private MetadataValue getDspaceObjectOwnerMetadata(Item item) {
        return this.getMetadataValue(item, "dspace.object.owner").filter(metadata -> UUIDUtils.fromString(metadata.getAuthority()) != null).orElseThrow(() -> new IllegalArgumentException("A profile item must have a valid dspace.object.owner metadata"));
    }

    private Optional<MetadataValue> getMetadataValue(Item item, String metadataField) {
        return this.getMetadataValues(item, metadataField).findFirst();
    }

    private Stream<MetadataValue> getMetadataValues(Item item, String metadataField) {
        return item.getMetadata().stream().filter(metadata -> metadataField.equals(metadata.getMetadataField().toString('.')));
    }
}

