/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.client;

import java.net.HttpURLConnection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.matomo.client.MatomoBulkRequest;
import org.dspace.matomo.client.MatomoClient;
import org.dspace.matomo.client.MatomoRequestBuilder;
import org.dspace.matomo.client.MatomoResponse;
import org.dspace.matomo.client.MatomoResponseReader;
import org.dspace.matomo.exception.MatomoClientException;
import org.dspace.matomo.model.MatomoCookieConverter;
import org.dspace.matomo.model.MatomoRequestDetails;

public abstract class MatomoAbstractClient<C, T, U>
implements MatomoClient {
    protected final String baseUrl;
    protected final String token;
    protected final MatomoRequestBuilder matomoRequestBuilder;
    protected final MatomoResponseReader matomoResponseReader;
    protected final C httpClient;
    protected final Logger log = LogManager.getLogger(this.getClass());

    public MatomoAbstractClient(String baseUrl, String token, MatomoRequestBuilder matomoRequestBuilder, MatomoResponseReader matomoResponseReader, C httpClient) {
        this.baseUrl = baseUrl;
        this.token = token;
        this.matomoRequestBuilder = matomoRequestBuilder;
        this.matomoResponseReader = matomoResponseReader;
        this.httpClient = httpClient;
    }

    protected T createRequest(String requestBody) {
        return this.createRequest(requestBody, "");
    }

    protected abstract T createRequest(String var1, String var2);

    protected abstract void executeRequest(String var1, String var2, BiConsumer<U, String> var3);

    protected abstract int getStatusCode(U var1);

    protected abstract String getResponseContent(U var1);

    @Override
    public void sendDetails(MatomoRequestDetails ... details) {
        this.sendDetails(Arrays.asList(details));
    }

    protected String createRequestBody(List<MatomoRequestDetails> details) {
        return this.matomoRequestBuilder.buildJSON(new MatomoBulkRequest(this.token, details));
    }

    @Override
    public void sendDetails(List<MatomoRequestDetails> details) {
        if (details == null || details.isEmpty()) {
            this.log.warn("Cannot send an empty request!");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.baseUrl)) {
            this.log.error("Cannot send these details {} to Matomo - No endpoint configured!", details);
            return;
        }
        try {
            this.executeRequest(this.createRequestBody(details), this.generateCookies(details), this::logError);
        }
        catch (Exception ex) {
            throw new MatomoClientException("An error occurs sending events to " + this.baseUrl, ex);
        }
    }

    protected String generateCookies(List<MatomoRequestDetails> details) {
        return MatomoCookieConverter.convert(details);
    }

    static void addCookies(HttpURLConnection connection, Map<String, String> cookies) {
        StringBuilder cookiesValue = new StringBuilder();
        if (cookies != null) {
            Iterator<Map.Entry<String, String>> iterator = cookies.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                cookiesValue.append(entry.getKey()).append("=").append(entry.getValue());
                if (!iterator.hasNext()) continue;
                cookiesValue.append("; ");
            }
            String requestCookies = connection.getRequestProperty("Cookie");
            if (!StringUtils.isEmpty((CharSequence)requestCookies)) {
                cookiesValue.append("; ").append(requestCookies);
            }
        }
        if (cookiesValue.length() > 0) {
            connection.setRequestProperty("Cookie", cookiesValue.toString());
        }
    }

    protected void logError(U response, String requestBody) {
        if (this.isNotSuccessful(response)) {
            String responseMessage = this.formatErrorMessage(response);
            this.log.error("Cannot register the event on Matomo, REQUEST: {} - RESPONSE: {}", (Object)requestBody, (Object)responseMessage);
            throw new MatomoClientException(responseMessage);
        }
        String responseBody = this.getResponseContent(response);
        MatomoResponse matomoResponse = this.matomoResponseReader.fromJSON(responseBody);
        if (matomoResponse == null || !"success".equals(matomoResponse.status()) || matomoResponse.invalid() > 0) {
            this.log.error("Unable to track requestBody: {}, response was: {}", (Object)requestBody, (Object)responseBody);
        }
    }

    protected boolean isNotSuccessful(U response) {
        int statusCode = this.getStatusCode(response);
        return statusCode < 200 || statusCode > 299;
    }

    protected String formatErrorMessage(U response) {
        return "Status " + this.getStatusCode(response) + ". Content: " + this.getResponseContent(response);
    }
}

