/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadataFieldMapping;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.MetadataContributor;
import org.dspace.importer.external.metadatamapping.transform.MetadataProcessorService;

public abstract class AbstractMetadataFieldMapping<RecordType>
implements MetadataFieldMapping<RecordType, MetadataContributor<RecordType>> {
    private Map<MetadataFieldConfig, MetadataContributor<RecordType>> metadataFieldMap;
    private static final Logger log = LogManager.getLogger(AbstractMetadataFieldMapping.class);
    private Map<MetadataFieldConfig, MetadataProcessorService> metadataProcessorMap;

    public void setMetadataProcessorMap(Map<MetadataFieldConfig, MetadataProcessorService> metadataProcessorMap) {
        this.metadataProcessorMap = metadataProcessorMap;
    }

    public MetadataProcessorService getMetadataProcessor(MetadataFieldConfig metadataField) {
        if (this.metadataProcessorMap != null) {
            return this.metadataProcessorMap.get(metadataField);
        }
        return null;
    }

    @Override
    public MetadatumDTO toDCValue(MetadataFieldConfig field, String value) {
        MetadatumDTO dcValue = new MetadatumDTO();
        if (field == null) {
            return null;
        }
        MetadataProcessorService metadataProcessor = this.getMetadataProcessor(field);
        if (metadataProcessor != null) {
            value = metadataProcessor.processMetadataValue(value);
        }
        dcValue.setValue(value);
        dcValue.setElement(field.getElement());
        dcValue.setQualifier(field.getQualifier());
        dcValue.setSchema(field.getSchema());
        return dcValue;
    }

    public Map<MetadataFieldConfig, MetadataContributor<RecordType>> getMetadataFieldMap() {
        return this.metadataFieldMap;
    }

    public void setMetadataFieldMap(Map<MetadataFieldConfig, MetadataContributor<RecordType>> metadataFieldMap) {
        this.metadataFieldMap = metadataFieldMap;
        for (MetadataContributor<RecordType> mc : metadataFieldMap.values()) {
            mc.setMetadataFieldMapping(this);
        }
    }

    @Override
    public Collection<MetadatumDTO> resultToDCValueMapping(RecordType record) {
        ArrayList<MetadatumDTO> values = new ArrayList<MetadatumDTO>();
        for (MetadataContributor<RecordType> query : this.getMetadataFieldMap().values()) {
            try {
                values.addAll(query.contributeMetadata(record));
            }
            catch (Exception e) {
                log.error("Error", (Throwable)e);
            }
        }
        return values;
    }
}

