/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.EPersonService;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthenticationServiceImpl
implements AuthenticationService {
    private final Logger log = LogManager.getLogger();
    @Autowired(required=true)
    protected EPersonService ePersonService;

    protected AuthenticationServiceImpl() {
    }

    public List<AuthenticationMethod> getAuthenticationMethodStack() {
        return Arrays.asList((AuthenticationMethod[])CoreServiceFactory.getInstance().getPluginService().getPluginSequence(AuthenticationMethod.class));
    }

    @Override
    public int authenticate(Context context, String username, String password, String realm, HttpServletRequest request) {
        return this.authenticateInternal(context, username, password, realm, request, false);
    }

    @Override
    public int authenticateImplicit(Context context, String username, String password, String realm, HttpServletRequest request) {
        return this.authenticateInternal(context, username, password, realm, request, true);
    }

    protected int authenticateInternal(Context context, String username, String password, String realm, HttpServletRequest request, boolean implicitOnly) {
        int bestRet = 5;
        for (AuthenticationMethod aMethodStack : this.getAuthenticationMethodStack()) {
            if (implicitOnly && !aMethodStack.isImplicit()) continue;
            int ret = 0;
            try {
                ret = aMethodStack.authenticate(context, username, password, realm, request);
            }
            catch (SQLException e) {
                ret = 4;
            }
            if (ret == 1) {
                this.updateLastActiveDate(context);
                context.setAuthenticationMethod(aMethodStack.getName());
                return ret;
            }
            if (ret >= bestRet) continue;
            bestRet = ret;
        }
        return bestRet;
    }

    @Override
    public void updateLastActiveDate(Context context) {
        EPerson me = context.getCurrentUser();
        if (me != null) {
            me.setLastActive(Instant.now());
            try {
                this.ePersonService.update(context, me);
            }
            catch (SQLException ex) {
                this.log.error("Could not update last-active stamp", (Throwable)ex);
            }
            catch (AuthorizeException ex) {
                this.log.error("Could not update last-active stamp", (Throwable)ex);
            }
        }
    }

    @Override
    public boolean canSelfRegister(Context context, HttpServletRequest request, String username) throws SQLException {
        for (AuthenticationMethod method : this.getAuthenticationMethodStack()) {
            if (!method.canSelfRegister(context, request, username)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowSetPassword(Context context, HttpServletRequest request, String username) throws SQLException {
        for (AuthenticationMethod method : this.getAuthenticationMethodStack()) {
            if (!method.allowSetPassword(context, request, username)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
        for (AuthenticationMethod method : this.getAuthenticationMethodStack()) {
            method.initEPerson(context, request, eperson);
        }
    }

    @Override
    public List<Group> getSpecialGroups(Context context, HttpServletRequest request) throws SQLException {
        ArrayList<Group> result = new ArrayList<Group>();
        int totalLen = 0;
        for (AuthenticationMethod method : this.getAuthenticationMethodStack()) {
            List<Group> gl;
            if (!method.areSpecialGroupsApplicable(context, request) || (gl = method.getSpecialGroups(context, request)).size() <= 0) continue;
            result.addAll(gl);
            totalLen += gl.size();
        }
        return result;
    }

    @Override
    public Iterator<AuthenticationMethod> authenticationMethodIterator() {
        return this.getAuthenticationMethodStack().iterator();
    }

    @Override
    public String getAuthenticationMethod(Context context, HttpServletRequest request) {
        Iterator<AuthenticationMethod> authenticationMethodIterator = this.authenticationMethodIterator();
        while (authenticationMethodIterator.hasNext()) {
            AuthenticationMethod authenticationMethod = authenticationMethodIterator.next();
            if (!authenticationMethod.isUsed(context, request)) continue;
            return authenticationMethod.getName();
        }
        return null;
    }

    @Override
    public boolean canChangePassword(Context context, EPerson ePerson, String currentPassword) {
        for (AuthenticationMethod method : this.getAuthenticationMethodStack()) {
            if (!method.getName().equals(context.getAuthenticationMethod())) continue;
            return method.canChangePassword(context, ePerson, currentPassword);
        }
        return false;
    }
}

