/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.SubmissionStepConfig;

public class SubmissionConfig
implements Serializable {
    private String submissionName = null;
    private boolean defaultConf = false;
    private SubmissionStepConfig[] submissionSteps = null;
    private static Logger log = LogManager.getLogger(SubmissionConfig.class);

    public SubmissionConfig(boolean isDefault, String submissionName, List<Map<String, String>> steps) {
        this.submissionName = submissionName;
        this.defaultConf = isDefault;
        ArrayList<SubmissionStepConfig> stepConfigs = new ArrayList<SubmissionStepConfig>();
        for (int stepNum = 0; stepNum < steps.size(); ++stepNum) {
            Map<String, String> stepInfo = steps.get(stepNum);
            SubmissionStepConfig step = new SubmissionStepConfig(stepInfo);
            step.setStepNumber(stepNum);
            stepConfigs.add(step);
            log.debug("Added step '" + step.getProcessingClassName() + "' as step #" + step.getStepNumber() + " of submission process " + submissionName);
        }
        this.submissionSteps = stepConfigs.toArray(new SubmissionStepConfig[stepConfigs.size()]);
    }

    public String getSubmissionName() {
        return this.submissionName;
    }

    public boolean isDefaultConf() {
        return this.defaultConf;
    }

    public int getNumberOfSteps() {
        return this.submissionSteps.length;
    }

    public SubmissionStepConfig getStep(int stepNum) {
        if (stepNum > this.submissionSteps.length - 1 || stepNum < 0) {
            return null;
        }
        return this.submissionSteps[stepNum];
    }

    public boolean hasMoreSteps(int stepNum) {
        return this.getStep(stepNum + 1) != null;
    }
}

