/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.factory;

import jakarta.servlet.http.Cookie;
import java.util.Set;
import org.dspace.matomo.factory.MatomoRequestDetailsEnricher;
import org.dspace.matomo.model.MatomoRequestDetails;
import org.dspace.usage.UsageEvent;

public class MatomoRequestCustomCookiesEnricher
implements MatomoRequestDetailsEnricher {
    private final Set<String> customCookies;

    public MatomoRequestCustomCookiesEnricher(String customCookies) {
        this.customCookies = Set.of(customCookies.split(","));
    }

    @Override
    public MatomoRequestDetails enrich(UsageEvent usageEvent, MatomoRequestDetails matomoRequestDetails) {
        Cookie[] cookies = usageEvent.getRequest().getCookies();
        if (cookies == null) {
            return matomoRequestDetails;
        }
        for (Cookie cookie : cookies) {
            String cookieName = cookie.getName();
            String baseName = null;
            if (cookieName != null && cookieName.contains(".")) {
                baseName = cookieName.substring(0, cookieName.indexOf("."));
            }
            if (baseName == null || !this.customCookies.contains(baseName)) continue;
            matomoRequestDetails.addCookie(cookieName, cookie.getValue());
        }
        return matomoRequestDetails;
    }
}

