/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.importer.external.metadatamapping.contributor.AbstractJsonPathMetadataProcessor;

public class InvertedIndexProcessor
extends AbstractJsonPathMetadataProcessor {
    private static final Logger log = LogManager.getLogger(InvertedIndexProcessor.class);
    private String path;

    @Override
    protected String getStringValue(JsonNode node) {
        if (node == null || node.isEmpty()) {
            return "";
        }
        JsonNode targetNode = node.at(this.path);
        if (targetNode.isMissingNode() || !targetNode.isObject()) {
            log.warn("The specified path {} is not a JSON array", (Object)this.path);
            return "";
        }
        TreeMap positionMap = new TreeMap();
        targetNode.fields().forEachRemaining(entry -> ((JsonNode)entry.getValue()).forEach(position -> positionMap.put(position.asInt(), (String)entry.getKey())));
        return String.join((CharSequence)" ", positionMap.values());
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected String getPath() {
        return "";
    }

    public void setPath(String path) {
        this.path = path;
    }
}

