/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.SortedSet;
import java.util.TreeSet;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.RegistrationDataMetadata;
import org.dspace.eperson.RegistrationTypeEnum;
import org.hibernate.annotations.SortNatural;

@Entity
@Table(name="registrationdata")
public class RegistrationData
implements ReloadableEntity<Integer> {
    @Id
    @Column(name="registrationdata_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="registrationdata_seq")
    @SequenceGenerator(name="registrationdata_seq", sequenceName="registrationdata_seq", allocationSize=1)
    private Integer id;
    @Column(name="email", length=64)
    private String email;
    @Column(name="token", length=48)
    private String token;
    @Column(name="expires")
    private Instant expires;
    @SortNatural
    @OneToMany(fetch=FetchType.LAZY, mappedBy="registrationData", cascade={CascadeType.ALL}, orphanRemoval=true)
    private SortedSet<RegistrationDataMetadata> metadata = new TreeSet<RegistrationDataMetadata>();
    @Column(name="registration_type")
    @Enumerated(value=EnumType.STRING)
    private RegistrationTypeEnum registrationType;
    @Column(name="net_id", length=64)
    private final String netId;

    protected RegistrationData() {
        this(null);
    }

    protected RegistrationData(String netId) {
        this.netId = netId;
    }

    @Override
    public Integer getID() {
        return this.id;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getToken() {
        return this.token;
    }

    void setToken(String token) {
        this.token = token;
    }

    public Instant getExpires() {
        return this.expires;
    }

    void setExpires(Instant expires) {
        this.expires = expires;
    }

    public RegistrationTypeEnum getRegistrationType() {
        return this.registrationType;
    }

    public void setRegistrationType(RegistrationTypeEnum registrationType) {
        this.registrationType = registrationType;
    }

    public SortedSet<RegistrationDataMetadata> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(SortedSet<RegistrationDataMetadata> metadata) {
        this.metadata = metadata;
    }

    public String getNetId() {
        return this.netId;
    }
}

