/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.embargo;

import java.sql.SQLException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Properties;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCDate;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.embargo.DefaultEmbargoSetter;
import org.dspace.embargo.EmbargoServiceImpl;
import org.dspace.services.factory.DSpaceServicesFactory;

public class DayTableEmbargoSetter
extends DefaultEmbargoSetter {
    @Override
    public DCDate parseTerms(Context context, Item item, String terms) throws SQLException, AuthorizeException {
        String termsOpen = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("embargo.terms.open");
        Properties termProps = this.getTermProperties();
        if (terms != null) {
            if (termsOpen.equals(terms)) {
                return EmbargoServiceImpl.FOREVER;
            }
            String days = termProps.getProperty(terms);
            if (days != null && days.length() > 0) {
                long lift = Instant.now().toEpochMilli() + Long.parseLong(days) * 24L * 60L * 60L * 1000L;
                return new DCDate(ZonedDateTime.ofInstant(Instant.ofEpochSecond(lift), ZoneOffset.UTC));
            }
        }
        return null;
    }

    private Properties getTermProperties() {
        Properties termProps = new Properties();
        String[] terms = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("embargo.terms.days");
        if (terms != null) {
            for (String term : terms) {
                String[] parts = term.trim().split(":");
                termProps.setProperty(parts[0].trim(), parts[1].trim());
            }
        }
        return termProps;
    }
}

