/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.administer;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.administer.MetadataImporter;
import org.dspace.app.util.XMLUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RegistryLoader {
    private static final Logger log = LogManager.getLogger(RegistryLoader.class);
    protected static BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();

    private RegistryLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        DefaultParser parser = new DefaultParser();
        Options options = RegistryLoader.createCommandLineOptions();
        try {
            CommandLine line = parser.parse(options, argv);
            if (line.hasOption('h') || line.getOptions().length == 0) {
                RegistryLoader.printHelp(options);
                System.exit(0);
            }
            Context context = new Context();
            context.turnOffAuthorisationSystem();
            try {
                if (line.hasOption('b')) {
                    String filename = line.getOptionValue('b');
                    if (StringUtils.isEmpty((CharSequence)filename)) {
                        System.err.println("No file path provided for bitstream format registry");
                        RegistryLoader.printHelp(options);
                        System.exit(1);
                    }
                    RegistryLoader.loadBitstreamFormats(context, filename);
                } else if (line.hasOption('m')) {
                    String filename = line.getOptionValue('m');
                    if (StringUtils.isEmpty((CharSequence)filename)) {
                        System.err.println("No file path provided for metadata registry");
                        RegistryLoader.printHelp(options);
                        System.exit(1);
                    }
                    MetadataImporter.loadRegistry(filename, true);
                } else {
                    System.err.println("No registry type specified");
                    RegistryLoader.printHelp(options);
                    System.exit(1);
                }
                context.complete();
                System.exit(0);
            }
            catch (Exception e) {
                log.fatal(LogHelper.getHeader(context, "error_loading_registries", ""), (Throwable)e);
                System.err.println("Error: \n - " + e.getMessage());
                System.exit(1);
            }
            finally {
                if (context != null && context.isValid()) {
                    context.abort();
                }
            }
        }
        catch (ParseException e) {
            System.err.println("Error parsing command-line arguments: " + e.getMessage());
            RegistryLoader.printHelp(options);
            System.exit(1);
        }
    }

    private static Options createCommandLineOptions() {
        Options options = new Options();
        options.addOption("b", "bitstream", true, "load bitstream format registry from specified file");
        options.addOption("m", "metadata", true, "load metadata registry from specified file");
        options.addOption("h", "help", false, "print this help message");
        return options;
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("RegistryLoader", "Load bitstream format or metadata registries into the database\n", options, "\nExamples:\n RegistryLoader -b bitstream-formats.xml\n RegistryLoader -m dc-types.xml", true);
    }

    public static void loadBitstreamFormats(Context context, String filename) throws SQLException, IOException, ParserConfigurationException, SAXException, TransformerException, AuthorizeException, XPathExpressionException {
        Document document = RegistryLoader.loadXML(filename);
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList typeNodes = (NodeList)xPath.compile("dspace-bitstream-types/bitstream-type").evaluate(document, XPathConstants.NODESET);
        for (int i = 0; i < typeNodes.getLength(); ++i) {
            Node n = typeNodes.item(i);
            RegistryLoader.loadFormat(context, n);
        }
        log.info(LogHelper.getHeader(context, "load_bitstream_formats", "number_loaded=" + typeNodes.getLength()));
    }

    private static void loadFormat(Context context, Node node) throws SQLException, AuthorizeException, XPathExpressionException {
        String mimeType = RegistryLoader.getElementData(node, "mimetype");
        String shortDesc = RegistryLoader.getElementData(node, "short_description");
        String desc = RegistryLoader.getElementData(node, "description");
        String supportLevelString = RegistryLoader.getElementData(node, "support_level");
        int supportLevel = Integer.parseInt(supportLevelString);
        String internalString = RegistryLoader.getElementData(node, "internal");
        boolean internal = Boolean.valueOf(internalString);
        String[] extensions = RegistryLoader.getRepeatedElementData(node, "extension");
        BitstreamFormat exists = bitstreamFormatService.findByMIMEType(context, mimeType);
        if (exists == null) {
            exists = bitstreamFormatService.findByShortDescription(context, shortDesc);
        }
        if (exists == null) {
            BitstreamFormat format = (BitstreamFormat)bitstreamFormatService.create(context);
            format.setMIMEType(mimeType);
            bitstreamFormatService.setShortDescription(context, format, shortDesc);
            format.setDescription(desc);
            format.setSupportLevel(supportLevel);
            format.setInternal(internal);
            ArrayList<String> extensionList = new ArrayList<String>();
            extensionList.addAll(Arrays.asList(extensions));
            format.setExtensions(extensionList);
            bitstreamFormatService.update(context, format);
        }
    }

    private static Document loadXML(String filename) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilder builder = XMLUtils.getTrustedDocumentBuilder(new String[0]);
        return builder.parse(new File(filename));
    }

    private static String getElementData(Node parentElement, String childName) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        Node childNode = (Node)xPath.compile(childName).evaluate(parentElement, XPathConstants.NODE);
        if (childNode == null) {
            return null;
        }
        Node dataNode = childNode.getFirstChild();
        if (dataNode == null) {
            return null;
        }
        String value = dataNode.getNodeValue().trim();
        return value;
    }

    private static String[] getRepeatedElementData(Node parentElement, String childName) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList childNodes = (NodeList)xPath.compile(childName).evaluate(parentElement, XPathConstants.NODESET);
        String[] data = new String[childNodes.getLength()];
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node dataNode = childNodes.item(i).getFirstChild();
            data[i] = dataNode.getNodeValue().trim();
        }
        return data;
    }
}

