/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.pubmed.service;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.FileMultipleOccurencesException;
import org.dspace.importer.external.exception.FileSourceException;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.service.AbstractImportMetadataSourceService;
import org.dspace.importer.external.service.components.FileSource;
import org.dspace.importer.external.service.components.QuerySource;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PubmedImportMetadataSourceServiceImpl
extends AbstractImportMetadataSourceService<Element>
implements QuerySource,
FileSource {
    private String urlFetch;
    private String urlSearch;
    private int attempt = 3;
    private List<String> supportedExtensions;
    @Autowired
    private LiveImportClient liveImportClient;

    public void setSupportedExtensions(List<String> supportedExtensions) {
        this.supportedExtensions = supportedExtensions;
    }

    @Override
    public List<String> getSupportedExtensions() {
        return this.supportedExtensions;
    }

    @Override
    public int getRecordsCount(String query) throws MetadataSourceException {
        return this.retry(new GetNbRecords(query));
    }

    @Override
    public int getRecordsCount(Query query) throws MetadataSourceException {
        return this.retry(new GetNbRecords(query));
    }

    @Override
    public Collection<ImportRecord> getRecords(String query, int start, int count) throws MetadataSourceException {
        return this.retry(new GetRecords(query, start, count));
    }

    @Override
    public Collection<ImportRecord> getRecords(Query query) throws MetadataSourceException {
        return this.retry(new GetRecords(query));
    }

    @Override
    public ImportRecord getRecord(String id) throws MetadataSourceException {
        return this.retry(new GetRecord(id));
    }

    @Override
    public ImportRecord getRecord(Query query) throws MetadataSourceException {
        return this.retry(new GetRecord(query));
    }

    @Override
    public String getImportSource() {
        return "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/";
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Item item) throws MetadataSourceException {
        return this.retry(new FindMatchingRecords(item));
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Query query) throws MetadataSourceException {
        return this.retry(new FindMatchingRecords(query));
    }

    @Override
    public void init() throws Exception {
    }

    private String getSingleElementValue(String src, String elementName) {
        String value = null;
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Document document = saxBuilder.build((Reader)new StringReader(src));
            Element root = document.getRootElement();
            XPathExpression xpath = XPathFactory.instance().compile("//" + elementName, Filters.element());
            Element record = (Element)xpath.evaluateFirst((Object)root);
            if (record != null) {
                value = record.getText();
            }
        }
        catch (IOException | JDOMException e) {
            value = null;
        }
        return value;
    }

    private List<Element> splitToRecords(String recordsSrc) {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxBuilder.setExpandEntities(false);
            Document document = saxBuilder.build((Reader)new StringReader(recordsSrc));
            Element root = document.getRootElement();
            XPathExpression xpath = XPathFactory.instance().compile("//PubmedArticle", Filters.element());
            List recordsList = xpath.evaluate((Object)root);
            return recordsList;
        }
        catch (IOException | JDOMException e) {
            return null;
        }
    }

    @Override
    public List<ImportRecord> getRecords(InputStream inputStream) throws FileSourceException {
        List<ImportRecord> list;
        InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
        try {
            String xml = CharStreams.toString((Readable)reader);
            list = this.parseXMLString(xml);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new FileSourceException("Cannot read XML from InputStream", e);
            }
        }
        ((Reader)reader).close();
        return list;
    }

    @Override
    public ImportRecord getRecord(InputStream inputStream) throws FileSourceException, FileMultipleOccurencesException {
        List<ImportRecord> importRecord = this.getRecords(inputStream);
        if (importRecord == null || importRecord.isEmpty()) {
            throw new FileSourceException("Cannot find (valid) record in File");
        }
        if (importRecord.size() > 1) {
            throw new FileMultipleOccurencesException("File contains more than one entry");
        }
        return importRecord.get(0);
    }

    private List<ImportRecord> parseXMLString(String xml) {
        LinkedList<ImportRecord> records = new LinkedList<ImportRecord>();
        List<Element> elements = this.splitToRecords(xml);
        for (Element record : elements) {
            records.add(this.transformSourceRecords(record));
        }
        return records;
    }

    public String getUrlFetch() {
        return this.urlFetch;
    }

    public void setUrlFetch(String urlFetch) {
        this.urlFetch = urlFetch;
    }

    public String getUrlSearch() {
        return this.urlSearch;
    }

    public void setUrlSearch(String urlSearch) {
        this.urlSearch = urlSearch;
    }

    private class GetNbRecords
    implements Callable<Integer> {
        private Query query;

        private GetNbRecords(String queryString) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
        }

        public GetNbRecords(Query query) {
            this.query = query;
        }

        @Override
        public Integer call() throws Exception {
            URIBuilder uriBuilder = new URIBuilder(PubmedImportMetadataSourceServiceImpl.this.urlSearch);
            uriBuilder.addParameter("db", "pubmed");
            uriBuilder.addParameter("term", this.query.getParameterAsClass("query", String.class));
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            String response = "";
            for (int countAttempt = 0; StringUtils.isBlank((CharSequence)response) && countAttempt <= PubmedImportMetadataSourceServiceImpl.this.attempt; ++countAttempt) {
                response = PubmedImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
            }
            if (StringUtils.isBlank((CharSequence)response)) {
                throw new RuntimeException("After " + PubmedImportMetadataSourceServiceImpl.this.attempt + " attempts to contact the PubMed service, a correct answer could not be received. The request was made with this URL:" + uriBuilder.toString());
            }
            return Integer.parseInt(PubmedImportMetadataSourceServiceImpl.this.getSingleElementValue(response, "Count"));
        }
    }

    private class GetRecords
    implements Callable<Collection<ImportRecord>> {
        private Query query;

        private GetRecords(String queryString, int start, int count) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
            this.query.addParameter("start", start);
            this.query.addParameter("count", count);
        }

        private GetRecords(Query q) {
            this.query = q;
        }

        @Override
        public Collection<ImportRecord> call() throws Exception {
            String queryString = this.query.getParameterAsClass("query", String.class);
            Integer start = this.query.getParameterAsClass("start", Integer.class);
            Integer count = this.query.getParameterAsClass("count", Integer.class);
            if (Objects.isNull(count) || count < 0) {
                count = 10;
            }
            if (Objects.isNull(start) || start < 0) {
                start = 0;
            }
            LinkedList<ImportRecord> records = new LinkedList<ImportRecord>();
            URIBuilder uriBuilder = new URIBuilder(PubmedImportMetadataSourceServiceImpl.this.urlSearch);
            uriBuilder.addParameter("db", "pubmed");
            uriBuilder.addParameter("retstart", start.toString());
            uriBuilder.addParameter("retmax", count.toString());
            uriBuilder.addParameter("usehistory", "y");
            uriBuilder.addParameter("term", queryString);
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            String response = "";
            int countAttempt = 0;
            while (StringUtils.isBlank((CharSequence)response) && countAttempt <= PubmedImportMetadataSourceServiceImpl.this.attempt) {
                ++countAttempt;
                long time = Instant.now().toEpochMilli() - PubmedImportMetadataSourceServiceImpl.this.lastRequest;
                if (time < PubmedImportMetadataSourceServiceImpl.this.interRequestTime) {
                    Thread.sleep(PubmedImportMetadataSourceServiceImpl.this.interRequestTime - time);
                }
                response = PubmedImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
                PubmedImportMetadataSourceServiceImpl.this.lastRequest = Instant.now().toEpochMilli();
            }
            if (StringUtils.isBlank((CharSequence)response)) {
                throw new RuntimeException("After " + PubmedImportMetadataSourceServiceImpl.this.attempt + " attempts to contact the PubMed service, a correct answer could not be received. The request was made with this URL:" + uriBuilder.toString());
            }
            String queryKey = PubmedImportMetadataSourceServiceImpl.this.getSingleElementValue(response, "QueryKey");
            String webEnv = PubmedImportMetadataSourceServiceImpl.this.getSingleElementValue(response, "WebEnv");
            URIBuilder uriBuilder2 = new URIBuilder(PubmedImportMetadataSourceServiceImpl.this.urlFetch);
            uriBuilder2.addParameter("db", "pubmed");
            uriBuilder2.addParameter("retstart", start.toString());
            uriBuilder2.addParameter("retmax", count.toString());
            uriBuilder2.addParameter("WebEnv", webEnv);
            uriBuilder2.addParameter("query_key", queryKey);
            uriBuilder2.addParameter("retmode", "xml");
            HashMap<String, Map<String, String>> params2 = new HashMap<String, Map<String, String>>();
            String response2 = "";
            countAttempt = 0;
            while (StringUtils.isBlank((CharSequence)response2) && countAttempt <= PubmedImportMetadataSourceServiceImpl.this.attempt) {
                ++countAttempt;
                long time = Instant.now().toEpochMilli() - PubmedImportMetadataSourceServiceImpl.this.lastRequest;
                if (time < PubmedImportMetadataSourceServiceImpl.this.interRequestTime) {
                    Thread.sleep(PubmedImportMetadataSourceServiceImpl.this.interRequestTime - time);
                }
                response2 = PubmedImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(1000, uriBuilder2.toString(), params2);
                PubmedImportMetadataSourceServiceImpl.this.lastRequest = Instant.now().toEpochMilli();
            }
            if (StringUtils.isBlank((CharSequence)response2)) {
                throw new RuntimeException("After " + PubmedImportMetadataSourceServiceImpl.this.attempt + " attempts to contact the PubMed service, a correct answer could not be received. The request was made with this URL:" + uriBuilder2.toString());
            }
            List<Element> elements = PubmedImportMetadataSourceServiceImpl.this.splitToRecords(response2);
            for (Element record : elements) {
                records.add(PubmedImportMetadataSourceServiceImpl.this.transformSourceRecords(record));
            }
            return records;
        }
    }

    private class GetRecord
    implements Callable<ImportRecord> {
        private Query query;

        private GetRecord(String id) {
            this.query = new Query();
            this.query.addParameter("id", id);
        }

        public GetRecord(Query q) {
            this.query = q;
        }

        @Override
        public ImportRecord call() throws Exception {
            URIBuilder uriBuilder = new URIBuilder(PubmedImportMetadataSourceServiceImpl.this.urlFetch);
            uriBuilder.addParameter("db", "pubmed");
            uriBuilder.addParameter("retmode", "xml");
            uriBuilder.addParameter("id", this.query.getParameterAsClass("id", String.class));
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            String response = "";
            for (int countAttempt = 0; StringUtils.isBlank((CharSequence)response) && countAttempt <= PubmedImportMetadataSourceServiceImpl.this.attempt; ++countAttempt) {
                response = PubmedImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
            }
            if (StringUtils.isBlank((CharSequence)response)) {
                throw new RuntimeException("After " + PubmedImportMetadataSourceServiceImpl.this.attempt + " attempts to contact the PubMed service, a correct answer could not be received. The request was made with this URL:" + uriBuilder.toString());
            }
            List<Element> elements = PubmedImportMetadataSourceServiceImpl.this.splitToRecords(response);
            return elements.isEmpty() ? null : PubmedImportMetadataSourceServiceImpl.this.transformSourceRecords(elements.get(0));
        }
    }

    private class FindMatchingRecords
    implements Callable<Collection<ImportRecord>> {
        private Query query;

        private FindMatchingRecords(Item item) throws MetadataSourceException {
            this.query = PubmedImportMetadataSourceServiceImpl.this.getGenerateQueryForItem().generateQueryForItem(item);
        }

        public FindMatchingRecords(Query q) {
            this.query = q;
        }

        @Override
        public Collection<ImportRecord> call() throws Exception {
            URIBuilder uriBuilder = new URIBuilder(PubmedImportMetadataSourceServiceImpl.this.urlSearch);
            uriBuilder.addParameter("db", "pubmed");
            uriBuilder.addParameter("usehistory", "y");
            uriBuilder.addParameter("term", this.query.getParameterAsClass("term", String.class));
            uriBuilder.addParameter("field", this.query.getParameterAsClass("field", String.class));
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            String response = "";
            int countAttempt = 0;
            while (StringUtils.isBlank((CharSequence)response) && countAttempt <= PubmedImportMetadataSourceServiceImpl.this.attempt) {
                ++countAttempt;
                long time = Instant.now().toEpochMilli() - PubmedImportMetadataSourceServiceImpl.this.lastRequest;
                if (time < PubmedImportMetadataSourceServiceImpl.this.interRequestTime) {
                    Thread.sleep(PubmedImportMetadataSourceServiceImpl.this.interRequestTime - time);
                }
                response = PubmedImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
                PubmedImportMetadataSourceServiceImpl.this.lastRequest = Instant.now().toEpochMilli();
            }
            if (StringUtils.isBlank((CharSequence)response)) {
                throw new RuntimeException("After " + PubmedImportMetadataSourceServiceImpl.this.attempt + " attempts to contact the PubMed service, a correct answer could not be received. The request was made with this URL:" + uriBuilder.toString());
            }
            String webEnv = PubmedImportMetadataSourceServiceImpl.this.getSingleElementValue(response, "WebEnv");
            String queryKey = PubmedImportMetadataSourceServiceImpl.this.getSingleElementValue(response, "QueryKey");
            URIBuilder uriBuilder2 = new URIBuilder(PubmedImportMetadataSourceServiceImpl.this.urlFetch);
            uriBuilder2.addParameter("db", "pubmed");
            uriBuilder2.addParameter("retmode", "xml");
            uriBuilder2.addParameter("WebEnv", webEnv);
            uriBuilder2.addParameter("query_key", queryKey);
            HashMap<String, Map<String, String>> params2 = new HashMap<String, Map<String, String>>();
            String response2 = "";
            countAttempt = 0;
            while (StringUtils.isBlank((CharSequence)response2) && countAttempt <= PubmedImportMetadataSourceServiceImpl.this.attempt) {
                ++countAttempt;
                long time = Instant.now().toEpochMilli() - PubmedImportMetadataSourceServiceImpl.this.lastRequest;
                if (time < PubmedImportMetadataSourceServiceImpl.this.interRequestTime) {
                    Thread.sleep(PubmedImportMetadataSourceServiceImpl.this.interRequestTime - time);
                }
                response2 = PubmedImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(1000, uriBuilder2.toString(), params2);
                PubmedImportMetadataSourceServiceImpl.this.lastRequest = Instant.now().toEpochMilli();
            }
            if (StringUtils.isBlank((CharSequence)response2)) {
                throw new RuntimeException("After " + PubmedImportMetadataSourceServiceImpl.this.attempt + " attempts to contact the PubMed service, a correct answer could not be received. The request was made with this URL:" + uriBuilder2.toString());
            }
            return PubmedImportMetadataSourceServiceImpl.this.parseXMLString(response2);
        }
    }
}

