/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.embargo;

import java.io.IOException;
import java.sql.SQLException;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCDate;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.service.PluginService;
import org.dspace.embargo.EmbargoLifter;
import org.dspace.embargo.EmbargoSetter;
import org.dspace.embargo.service.EmbargoService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class EmbargoServiceImpl
implements EmbargoService {
    private final Logger log = LogManager.getLogger(EmbargoServiceImpl.class);
    protected String terms_schema = null;
    protected String terms_element = null;
    protected String terms_qualifier = null;
    protected String lift_schema = null;
    protected String lift_element = null;
    protected String lift_qualifier = null;
    protected EmbargoSetter setter = null;
    protected EmbargoLifter lifter = null;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    @Autowired(required=true)
    protected PluginService pluginService;

    protected EmbargoServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEmbargo(Context context, Item item) throws SQLException, AuthorizeException {
        DCDate myLift = this.getEmbargoTermsAsDate(context, item);
        if (myLift == null && (myLift = this.recoverEmbargoDate(item)) == null) {
            return;
        }
        String slift = myLift.toString();
        try {
            context.turnOffAuthorisationSystem();
            this.itemService.clearMetadata(context, item, this.lift_schema, this.lift_element, this.lift_qualifier, "*");
            this.itemService.addMetadata(context, item, this.lift_schema, this.lift_element, this.lift_qualifier, null, slift);
            this.log.info("Set embargo on Item " + item.getHandle() + ", expires on: " + slift);
            this.setter.setEmbargo(context, item);
            this.itemService.update(context, item);
        }
        finally {
            context.restoreAuthSystemState();
        }
    }

    @Override
    public DCDate getEmbargoTermsAsDate(Context context, Item item) throws SQLException, AuthorizeException {
        List<MetadataValue> terms = this.itemService.getMetadata(item, this.terms_schema, this.terms_element, this.terms_qualifier, "*");
        DCDate result = null;
        if (terms == null) {
            return null;
        }
        result = this.setter.parseTerms(context, item, terms.size() > 0 ? terms.get(0).getValue() : null);
        if (result == null) {
            return null;
        }
        ZonedDateTime liftDate = result.toDate();
        if (liftDate == null) {
            throw new IllegalArgumentException("Embargo lift date is uninterpretable:  " + result.toString());
        }
        return result;
    }

    @Override
    public void liftEmbargo(Context context, Item item) throws SQLException, AuthorizeException, IOException {
        this.itemService.clearMetadata(context, item, this.lift_schema, this.lift_element, this.lift_qualifier, "*");
        this.itemService.clearMetadata(context, item, MetadataSchemaEnum.DC.getName(), "date", "available", "*");
        this.itemService.addMetadata(context, item, MetadataSchemaEnum.DC.getName(), "date", "available", null, DCDate.getCurrent().toString());
        this.log.info("Lifting embargo on Item " + item.getHandle());
        this.itemService.update(context, item);
    }

    public void init() throws Exception {
        if (this.terms_schema == null) {
            String terms = this.configurationService.getProperty("embargo.field.terms");
            String lift = this.configurationService.getProperty("embargo.field.lift");
            if (terms == null || lift == null) {
                throw new IllegalStateException("Missing one or more of the required DSpace configuration properties for EmbargoManager, check your configuration file.");
            }
            this.terms_schema = this.getSchemaOf(terms);
            this.terms_element = this.getElementOf(terms);
            this.terms_qualifier = this.getQualifierOf(terms);
            this.lift_schema = this.getSchemaOf(lift);
            this.lift_element = this.getElementOf(lift);
            this.lift_qualifier = this.getQualifierOf(lift);
            this.setter = (EmbargoSetter)this.pluginService.getSinglePlugin(EmbargoSetter.class);
            if (this.setter == null) {
                throw new IllegalStateException("The EmbargoSetter plugin was not defined in DSpace configuration.");
            }
            this.lifter = (EmbargoLifter)this.pluginService.getSinglePlugin(EmbargoLifter.class);
            if (this.lifter == null) {
                throw new IllegalStateException("The EmbargoLifter plugin was not defined in DSpace configuration.");
            }
        }
    }

    protected String getSchemaOf(String field) {
        String[] sa = field.split("\\.", 3);
        return sa[0];
    }

    protected String getElementOf(String field) {
        String[] sa = field.split("\\.", 3);
        return sa.length > 1 ? sa[1] : null;
    }

    protected String getQualifierOf(String field) {
        String[] sa = field.split("\\.", 3);
        return sa.length > 2 ? sa[2] : null;
    }

    protected DCDate recoverEmbargoDate(Item item) {
        DCDate liftDate = null;
        List<MetadataValue> lift = this.itemService.getMetadata(item, this.lift_schema, this.lift_element, this.lift_qualifier, "*");
        if (lift.size() > 0 && (liftDate = new DCDate(lift.get(0).getValue())).toDate().isBefore(ZonedDateTime.now())) {
            liftDate = null;
        }
        return liftDate;
    }

    @Override
    public void checkEmbargo(Context context, Item item) throws SQLException, IOException, AuthorizeException {
        this.setter.checkEmbargo(context, item);
    }

    @Override
    public List<MetadataValue> getLiftMetadata(Context context, Item item) {
        return this.itemService.getMetadata(item, this.lift_schema, this.lift_element, this.lift_qualifier, "*");
    }

    @Override
    public Iterator<Item> findItemsByLiftMetadata(Context context) throws SQLException, IOException, AuthorizeException {
        return this.itemService.findByMetadataField(context, this.lift_schema, this.lift_element, this.lift_qualifier, "*");
    }
}

