/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.io.IOException;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.discovery.IndexClientOptions;
import org.dspace.discovery.IndexDiscoveryScriptConfiguration;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.IndexingService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.indexobject.IndexableCollection;
import org.dspace.discovery.indexobject.IndexableCommunity;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.discovery.indexobject.factory.IndexFactory;
import org.dspace.discovery.indexobject.factory.IndexObjectFactoryFactory;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.utils.DSpace;

public class IndexClient
extends DSpaceRunnable<IndexDiscoveryScriptConfiguration> {
    private Context context;
    private IndexingService indexer = (IndexingService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(IndexingService.class.getName(), IndexingService.class);
    private IndexClientOptions indexClientOptions;

    @Override
    public void internalRun() throws Exception {
        String param;
        List indexableObjectTypes;
        if (this.indexClientOptions == IndexClientOptions.HELP) {
            this.printHelp();
            return;
        }
        String type = null;
        if (this.commandLine.hasOption("t") && !(indexableObjectTypes = IndexObjectFactoryFactory.getInstance().getIndexFactories().stream().map(indexFactory -> indexFactory.getType()).collect(Collectors.toList())).contains(type = this.commandLine.getOptionValue("t"))) {
            this.handler.handleException(String.format("%s is not a valid indexable object type, options: %s", type, Arrays.toString(indexableObjectTypes.toArray())));
        }
        Optional<Object> indexableObject = Optional.empty();
        if (!(this.indexClientOptions != IndexClientOptions.REMOVE && this.indexClientOptions != IndexClientOptions.INDEX || (indexableObject = this.resolveIndexableObject(this.context, param = this.indexClientOptions == IndexClientOptions.REMOVE ? this.commandLine.getOptionValue('r') : this.commandLine.getOptionValue('i'))).isPresent())) {
            throw new IllegalArgumentException("Cannot resolve " + param + " to a DSpace object");
        }
        switch (this.indexClientOptions) {
            case REMOVE: {
                this.handler.logInfo("Removing " + this.commandLine.getOptionValue("r") + " from Index");
                this.indexer.unIndexContent(this.context, ((IndexableObject)indexableObject.get()).getUniqueIndexID());
                break;
            }
            case CLEAN: {
                this.handler.logInfo("Cleaning Index");
                this.indexer.cleanIndex();
                break;
            }
            case DELETE: {
                this.handler.logInfo("Deleting Index");
                this.indexer.deleteIndex();
                break;
            }
            case BUILD: 
            case BUILDANDSPELLCHECK: {
                this.handler.logInfo("(Re)building index from scratch.");
                if (StringUtils.isNotBlank((CharSequence)type)) {
                    this.handler.logWarning(String.format("Type option, %s, not applicable for entire index rebuild option, b, type will be ignored", "t"));
                }
                this.indexer.deleteIndex();
                this.indexer.createIndex(this.context);
                if (this.indexClientOptions != IndexClientOptions.BUILDANDSPELLCHECK) break;
                this.checkRebuildSpellCheck(this.commandLine, this.indexer);
                break;
            }
            case OPTIMIZE: {
                this.handler.logInfo("Optimizing search core.");
                this.indexer.optimize();
                break;
            }
            case SPELLCHECK: {
                this.checkRebuildSpellCheck(this.commandLine, this.indexer);
                break;
            }
            case INDEX: {
                this.handler.logInfo("Indexing " + this.commandLine.getOptionValue('i') + " force " + this.commandLine.hasOption("f"));
                long startTimeMillis = Instant.now().toEpochMilli();
                long count = this.indexAll(this.indexer, ContentServiceFactory.getInstance().getItemService(), this.context, (IndexableObject)indexableObject.get());
                long seconds = (Instant.now().toEpochMilli() - startTimeMillis) / 1000L;
                this.handler.logInfo("Indexed " + count + " object" + (count > 1L ? "s" : "") + " in " + seconds + " seconds");
                break;
            }
            case UPDATE: 
            case UPDATEANDSPELLCHECK: {
                this.handler.logInfo("Updating Index");
                this.indexer.updateIndex(this.context, false, type);
                if (this.indexClientOptions != IndexClientOptions.UPDATEANDSPELLCHECK) break;
                this.checkRebuildSpellCheck(this.commandLine, this.indexer);
                break;
            }
            case FORCEUPDATE: 
            case FORCEUPDATEANDSPELLCHECK: {
                this.handler.logInfo("Updating Index");
                this.indexer.updateIndex(this.context, true, type);
                if (this.indexClientOptions != IndexClientOptions.FORCEUPDATEANDSPELLCHECK) break;
                this.checkRebuildSpellCheck(this.commandLine, this.indexer);
                break;
            }
            default: {
                this.handler.handleException("Invalid index client option.");
            }
        }
        this.handler.logInfo("Done with indexing");
    }

    @Override
    public IndexDiscoveryScriptConfiguration getScriptConfiguration() {
        return (IndexDiscoveryScriptConfiguration)new DSpace().getServiceManager().getServiceByName("index-discovery", IndexDiscoveryScriptConfiguration.class);
    }

    @Override
    public void setup() throws ParseException {
        try {
            this.context = new Context(Context.Mode.READ_ONLY);
            this.context.turnOffAuthorisationSystem();
        }
        catch (Exception e) {
            throw new ParseException("Unable to create a new DSpace Context: " + e.getMessage());
        }
        this.indexClientOptions = IndexClientOptions.getIndexClientOption(this.commandLine);
    }

    private Optional<IndexableObject> resolveIndexableObject(Context context, String param) throws SQLException {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(param);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uuid != null) {
            Item item = (Item)ContentServiceFactory.getInstance().getItemService().find(context, uuid);
            if (item != null) {
                return Optional.of(new IndexableItem(item));
            }
            Community community = (Community)ContentServiceFactory.getInstance().getCommunityService().find(context, uuid);
            if (community != null) {
                return Optional.of(new IndexableCommunity(community));
            }
            Collection collection = (Collection)ContentServiceFactory.getInstance().getCollectionService().find(context, uuid);
            if (collection != null) {
                return Optional.of(new IndexableCollection(collection));
            }
        } else {
            DSpaceObject dso = HandleServiceFactory.getInstance().getHandleService().resolveToObject(context, param);
            if (dso != null) {
                IndexFactory indexableObjectService = IndexObjectFactoryFactory.getInstance().getIndexFactoryByType(Constants.typeText[dso.getType()]);
                return indexableObjectService.findIndexableObject(context, dso.getID().toString());
            }
        }
        return Optional.empty();
    }

    private long indexAll(IndexingService indexingService, ItemService itemService, Context context, IndexableObject indexableObject) throws IOException, SearchServiceException, SQLException {
        long count = 0L;
        boolean commit = indexableObject instanceof IndexableCommunity || indexableObject instanceof IndexableCollection;
        indexingService.indexContent(context, indexableObject, true, commit);
        ++count;
        if (indexableObject instanceof IndexableCommunity) {
            Community community = (Community)indexableObject.getIndexedObject();
            String communityHandle = community.getHandle();
            for (Community subcommunity : community.getSubcommunities()) {
                count += this.indexAll(indexingService, itemService, context, new IndexableCommunity(subcommunity));
                context.uncacheEntity(subcommunity);
            }
            Community reloadedCommunity = (Community)HandleServiceFactory.getInstance().getHandleService().resolveToObject(context, communityHandle);
            for (Collection collection : reloadedCommunity.getCollections()) {
                count += this.indexAll(indexingService, itemService, context, new IndexableCollection(collection));
                context.uncacheEntity(collection);
            }
        } else if (indexableObject instanceof IndexableCollection) {
            Collection collection = (Collection)indexableObject.getIndexedObject();
            Iterator<Item> itemIterator = itemService.findByCollection(context, collection);
            while (itemIterator.hasNext()) {
                Item item = itemIterator.next();
                indexingService.indexContent(context, new IndexableItem(item), true, false);
                ++count;
                context.uncacheEntity(item);
            }
            indexingService.commit();
        }
        return count;
    }

    protected void checkRebuildSpellCheck(CommandLine line, IndexingService indexer) throws SearchServiceException, IOException {
        this.handler.logInfo("Rebuilding spell checker.");
        indexer.buildSpellCheck();
    }
}

