/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.sql.SQLException;
import java.util.List;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authenticate.OidcAuthenticationBean;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.kernel.ServiceManager;
import org.dspace.utils.DSpace;

public class OidcAuthentication
implements AuthenticationMethod {
    private final ServiceManager serviceManager = new DSpace().getServiceManager();
    private static final String OIDC_AUTHENTICATED = "oidc.authenticated";

    @Override
    public boolean canSelfRegister(Context context, HttpServletRequest request, String username) throws SQLException {
        return this.getOidcAuthentication().canSelfRegister(context, request, username);
    }

    @Override
    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
        this.getOidcAuthentication().initEPerson(context, request, eperson);
    }

    @Override
    public boolean allowSetPassword(Context context, HttpServletRequest request, String username) throws SQLException {
        return this.getOidcAuthentication().allowSetPassword(context, request, username);
    }

    @Override
    public boolean isImplicit() {
        return this.getOidcAuthentication().isImplicit();
    }

    @Override
    public List<Group> getSpecialGroups(Context context, HttpServletRequest request) throws SQLException {
        return this.getOidcAuthentication().getSpecialGroups(context, request);
    }

    @Override
    public int authenticate(Context context, String username, String password, String realm, HttpServletRequest request) throws SQLException {
        return this.getOidcAuthentication().authenticate(context, username, password, realm, request);
    }

    @Override
    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        return this.getOidcAuthentication().loginPageURL(context, request, response);
    }

    @Override
    public String getName() {
        return this.getOidcAuthentication().getName();
    }

    private OidcAuthenticationBean getOidcAuthentication() {
        return (OidcAuthenticationBean)this.serviceManager.getServiceByName("oidcAuthentication", OidcAuthenticationBean.class);
    }

    @Override
    public boolean isUsed(Context context, HttpServletRequest request) {
        return request != null && context.getCurrentUser() != null && request.getAttribute(OIDC_AUTHENTICATED) != null;
    }

    @Override
    public boolean canChangePassword(Context context, EPerson ePerson, String currentPassword) {
        return false;
    }
}

