/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.dspace.app.mediafilter.BrandText;

public class Brand {
    private final int brandWidth;
    private final int brandHeight;
    private final Font font;
    private final int xOffset;

    public Brand(int brandWidth, int brandHeight, Font font, int xOffset) {
        this.brandWidth = brandWidth;
        this.brandHeight = brandHeight;
        this.font = font;
        this.xOffset = xOffset;
    }

    public BufferedImage create(String brandLeftText, String shortLeftText, String brandRightText) {
        BrandText[] allBrandText = null;
        BufferedImage brandImage = new BufferedImage(this.brandWidth, this.brandHeight, 1);
        allBrandText = this.brandWidth >= 350 ? new BrandText[]{new BrandText("bl", brandLeftText), new BrandText("br", brandRightText)} : (this.brandWidth >= 190 ? new BrandText[]{new BrandText("bl", shortLeftText), new BrandText("br", brandRightText)} : new BrandText[]{new BrandText("br", brandRightText)});
        if (allBrandText != null && allBrandText.length > 0) {
            for (int i = 0; i < allBrandText.length; ++i) {
                this.drawImage(brandImage, allBrandText[i]);
            }
        }
        return brandImage;
    }

    private void drawImage(BufferedImage brandImage, BrandText brandText) {
        int imgWidth = brandImage.getWidth();
        int imgHeight = brandImage.getHeight();
        Graphics2D g2 = brandImage.createGraphics();
        g2.setFont(this.font);
        FontMetrics fm = g2.getFontMetrics();
        int bWidth = fm.stringWidth(brandText.getText()) + this.xOffset * 2 + 1;
        int bHeight = fm.getHeight();
        int bx = 0;
        int by = 0;
        if (brandText.getLocation().equals("tl")) {
            bx = 0;
            by = 0;
        } else if (brandText.getLocation().equals("tr")) {
            bx = imgWidth - bWidth;
            by = 0;
        } else if (brandText.getLocation().equals("bl")) {
            bx = 0;
            by = imgHeight - bHeight;
        } else if (brandText.getLocation().equals("br")) {
            bx = imgWidth - bWidth;
            by = imgHeight - bHeight;
        }
        Rectangle box = new Rectangle(bx, by, bWidth, bHeight);
        int tx = bx + this.xOffset;
        int ty = by + fm.getAscent();
        g2.setColor(Color.black);
        g2.fill(box);
        g2.setColor(Color.white);
        g2.drawString(brandText.getText(), tx, ty);
    }
}

