/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.client;

import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.dspace.app.client.DSpaceProxyRoutePlanner;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;
import org.springframework.beans.factory.annotation.Autowired;

public class DSpaceHttpClientFactory {
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private DSpaceProxyRoutePlanner proxyRoutePlanner;
    @Autowired(required=false)
    private List<HttpRequestInterceptor> requestInterceptors;
    @Autowired(required=false)
    private List<HttpResponseInterceptor> responseInterceptors;

    public static DSpaceHttpClientFactory getInstance() {
        return (DSpaceHttpClientFactory)new DSpace().getSingletonService(DSpaceHttpClientFactory.class);
    }

    public CloseableHttpClient build() {
        return this.build(HttpClientBuilder.create(), true);
    }

    public HttpClientBuilder builder(boolean setProxy) {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (setProxy) {
            clientBuilder.setRoutePlanner((HttpRoutePlanner)this.proxyRoutePlanner);
        }
        this.getRequestInterceptors().forEach(arg_0 -> ((HttpClientBuilder)clientBuilder).addInterceptorLast(arg_0));
        this.getResponseInterceptors().forEach(arg_0 -> ((HttpClientBuilder)clientBuilder).addInterceptorLast(arg_0));
        return clientBuilder;
    }

    public CloseableHttpClient buildWithoutProxy() {
        return this.build(HttpClientBuilder.create(), false);
    }

    public CloseableHttpClient buildWithoutAutomaticRetries(int maxConnTotal) {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create().disableAutomaticRetries().setMaxConnTotal(maxConnTotal);
        return this.build(clientBuilder, true);
    }

    public CloseableHttpClient buildWithRequestConfig(RequestConfig requestConfig) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig);
        return this.build(httpClientBuilder, true);
    }

    private CloseableHttpClient build(HttpClientBuilder clientBuilder, boolean setProxy) {
        if (setProxy) {
            clientBuilder.setRoutePlanner((HttpRoutePlanner)this.proxyRoutePlanner);
        }
        this.getRequestInterceptors().forEach(arg_0 -> ((HttpClientBuilder)clientBuilder).addInterceptorLast(arg_0));
        this.getResponseInterceptors().forEach(arg_0 -> ((HttpClientBuilder)clientBuilder).addInterceptorLast(arg_0));
        return clientBuilder.build();
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public List<HttpRequestInterceptor> getRequestInterceptors() {
        return ListUtils.emptyIfNull(this.requestInterceptors);
    }

    public void setRequestInterceptors(List<HttpRequestInterceptor> requestInterceptors) {
        this.requestInterceptors = requestInterceptors;
    }

    public List<HttpResponseInterceptor> getResponseInterceptors() {
        return ListUtils.emptyIfNull(this.responseInterceptors);
    }

    public void setResponseInterceptors(List<HttpResponseInterceptor> responseInterceptors) {
        this.responseInterceptors = responseInterceptors;
    }

    public DSpaceProxyRoutePlanner getProxyRoutePlanner() {
        return this.proxyRoutePlanner;
    }

    public void setProxyRoutePlanner(DSpaceProxyRoutePlanner proxyRoutePlanner) {
        this.proxyRoutePlanner = proxyRoutePlanner;
    }
}

