/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.testing;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PubMedToImport {
    private static final Logger log = LogManager.getLogger(PubMedToImport.class);
    private static File outputDir = null;

    private PubMedToImport() {
    }

    public static void main(String[] args) {
        Options options = new Options();
        options.addOption(new Option("s", "source", true, "Source xml"));
        options.addOption(new Option("o", "output", true, "Output directory"));
        try {
            CommandLine cli = new DefaultParser().parse(options, args);
            String source = cli.getOptionValue("s");
            String output = cli.getOptionValue("o");
            if (!new File(source).exists()) {
                throw new IllegalArgumentException("Source file does not exist");
            }
            outputDir = new File(output);
            if (outputDir.exists()) {
                if (outputDir.list().length > 0) {
                    throw new IllegalStateException("Output directory must be empty");
                }
            } else if (!outputDir.mkdirs()) {
                throw new IllegalStateException("Unable to create output directory");
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(source, (DefaultHandler)new PubMedHandler());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class PubMedHandler
    extends DefaultHandler {
        private static int recordCount = 1;
        private static List<MockMetadataValue> dcValues;
        private static StringBuilder value;
        private static StringBuilder lastName;
        private static StringBuilder firstName;
        private static boolean isCorrection;
        private static boolean isLastName;
        private static boolean isFirstName;

        private PubMedHandler() {
        }

        private static void addDCValue(String element, String qualifier, String value) {
            if (dcValues == null) {
                dcValues = new ArrayList<MockMetadataValue>();
            }
            MockMetadataValue thisValue = new MockMetadataValue();
            thisValue.schema = "dc";
            thisValue.element = element;
            thisValue.qualifier = qualifier;
            thisValue.value = value;
            dcValues.add(thisValue);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("PubmedArticle".equals(qName)) {
                System.out.println("Starting record " + recordCount);
            } else if ("CommensCorrectionsList".equals(qName)) {
                isCorrection = true;
            } else if ("ForeName".equals(qName)) {
                isFirstName = true;
                firstName = new StringBuilder();
            } else if ("LastName".equals(qName)) {
                isLastName = true;
                lastName = new StringBuilder();
            } else {
                value = new StringBuilder();
            }
            super.startElement(uri, localName, qName, attributes);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!isCorrection) {
                if ("PMID".equals(qName)) {
                    PubMedHandler.addDCValue("identifier", null, value.toString());
                } else if ("ISSN".equals(qName)) {
                    PubMedHandler.addDCValue("identifier", "issn", value.toString());
                } else if ("ArticleTitle".equals(qName)) {
                    PubMedHandler.addDCValue("title", null, value.toString());
                } else if ("AbstractText".equals(qName)) {
                    PubMedHandler.addDCValue("description", "abstract", value.toString());
                } else if ("PublicationType".equals(qName)) {
                    PubMedHandler.addDCValue("type", null, value.toString());
                } else if ("Author".equals(qName)) {
                    PubMedHandler.addDCValue("contributor", "author", lastName + ", " + firstName);
                } else if ("DescriptorName".equals(qName)) {
                    PubMedHandler.addDCValue("subject", "mesh", value.toString());
                }
            } else if ("MedlineCitation".equals(qName)) {
                isCorrection = false;
            }
            if ("PubmedArticle".equals(qName)) {
                try {
                    this.writeItem();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to export record", e);
                }
                System.out.println("Ending record " + recordCount);
                ++recordCount;
            }
            isFirstName = false;
            isLastName = false;
            super.endElement(uri, localName, qName);
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            if (isFirstName) {
                firstName.append(chars, start, length);
            } else if (isLastName) {
                lastName.append(chars, start, length);
            } else {
                value.append(chars, start, length);
            }
            super.characters(chars, start, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeItem() throws IOException {
            File itemDir = new File(outputDir, String.valueOf(recordCount));
            itemDir.mkdirs();
            new File(itemDir, "contents").createNewFile();
            Document doc = new Document();
            Element root = new Element("dublin_core");
            doc.setRootElement(root);
            for (MockMetadataValue dcValue : dcValues) {
                Element dcNode = new Element("dcvalue");
                dcNode.setAttribute("element", dcValue.element);
                if (!StringUtils.isEmpty((CharSequence)dcValue.qualifier)) {
                    dcNode.setAttribute("qualifier", dcValue.qualifier);
                }
                dcNode.setText(dcValue.value);
                root.addContent((Content)dcNode);
            }
            File dc = new File(itemDir, "dublin_core.xml");
            XMLOutputter dcOutput = new XMLOutputter(Format.getPrettyFormat().setEncoding("UTF-8"));
            try (OutputStream out = null;){
                out = new BufferedOutputStream(new FileOutputStream(dc));
                dcOutput.output(doc, out);
            }
            dcValues.clear();
        }

        static {
            isCorrection = false;
            isLastName = false;
            isFirstName = false;
        }
    }

    protected static class MockMetadataValue {
        public String schema;
        public String element;
        public String qualifier;
        public String value;

        protected MockMetadataValue() {
        }
    }
}

