/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.bitstore;

import com.google.common.hash.HashCode;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.common.net.MediaType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.core.Context;
import org.dspace.curate.Utils;
import org.dspace.storage.bitstore.BaseBitStoreService;
import org.dspace.storage.bitstore.BitstreamByteSource;
import org.dspace.storage.bitstore.factory.StorageServiceFactory;
import org.dspace.storage.bitstore.service.BitstreamStorageService;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.io.ContentMetadata;
import org.jclouds.javax.annotation.Nullable;

public class JCloudBitStoreService
extends BaseBitStoreService {
    private static final Logger log = LogManager.getLogger(JCloudBitStoreService.class);
    private Properties properties;
    private String providerOrApi;
    private ContextBuilder builder;
    private BlobStoreContext blobStoreContext;
    private String container;
    private String subfolder = null;
    private String identity;
    private String credential;
    private String endpoint;
    private boolean useRelativePath;
    private boolean enabled = false;
    private int counter = 0;
    private int maxCounter = -1;
    private static final String CSA = "MD5";

    public JCloudBitStoreService() {
    }

    public JCloudBitStoreService(String providerOrApi) {
        this.providerOrApi = providerOrApi;
    }

    protected JCloudBitStoreService(BlobStoreContext blobStoreContext, String providerOrApi) {
        this.blobStoreContext = blobStoreContext;
        this.providerOrApi = providerOrApi;
    }

    public void setUseRelativePath(boolean useRelativePath) {
        this.useRelativePath = useRelativePath;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public String getSubfolder() {
        return this.subfolder;
    }

    public void setSubfolder(String subfolder) {
        this.subfolder = subfolder;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public void setCredentials(@Nullable String credential) {
        this.credential = credential;
    }

    public void setProviderOrApi(String providerOrApi) {
        this.providerOrApi = providerOrApi;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setMaxCounter(int maxCounter) {
        this.maxCounter = maxCounter;
    }

    public void setOverrides(Properties overrides) {
        this.properties = overrides;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void init() throws IOException {
        if (this.isInitialized()) {
            return;
        }
        try {
            this.builder = ContextBuilder.newBuilder((String)this.providerOrApi);
            if (StringUtils.isNotEmpty((CharSequence)this.endpoint)) {
                this.builder = this.builder.endpoint(this.endpoint);
            }
            if (this.properties != null && !this.properties.isEmpty()) {
                this.builder = this.builder.overrides(this.properties);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.identity) && StringUtils.isNotEmpty((CharSequence)this.credential)) {
                this.builder = this.builder.credentials(this.identity, this.credential);
            }
            this.blobStoreContext = (BlobStoreContext)this.builder.buildView(BlobStoreContext.class);
            this.initialized = true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.initialized = false;
        }
    }

    private synchronized void refreshContextIfNeeded() {
        if (this.maxCounter < 0) {
            return;
        }
        ++this.counter;
        if (this.counter == this.maxCounter) {
            this.counter = 0;
            this.blobStoreContext.close();
            this.blobStoreContext = (BlobStoreContext)this.builder.buildView(BlobStoreContext.class);
        }
    }

    @Override
    public String generateId() {
        return org.dspace.core.Utils.generateKey();
    }

    @Override
    public InputStream get(Bitstream bitstream) throws IOException {
        File file = this.getFile(bitstream);
        return this.get(file);
    }

    private InputStream get(File file) throws IOException {
        BlobStore blobStore = this.blobStoreContext.getBlobStore();
        if (blobStore.blobExists(this.getContainer(), file.toString())) {
            Blob blob = blobStore.getBlob(this.getContainer(), file.toString());
            this.refreshContextIfNeeded();
            return blob.getPayload().openStream();
        }
        throw new IOException("File not found: " + file);
    }

    @Override
    public void remove(Bitstream bitstream) throws IOException {
        File file = this.getFile(bitstream);
        BlobStore blobStore = this.blobStoreContext.getBlobStore();
        blobStore.removeBlob(this.getContainer(), file.toString());
        this.deleteParents(file);
    }

    public String getFullKey(String id) {
        StringBuilder bufFilename = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)this.subfolder)) {
            bufFilename.append(this.subfolder);
            this.appendSeparator(bufFilename);
        }
        if (this.useRelativePath) {
            bufFilename.append(this.getRelativePath(id));
        } else {
            bufFilename.append(id);
        }
        if (log.isDebugEnabled()) {
            log.debug("Container filepath for " + id + " is " + bufFilename.toString());
        }
        return bufFilename.toString();
    }

    private String getRelativePath(String sInternalId) {
        BitstreamStorageService bitstreamStorageService = StorageServiceFactory.getInstance().getBitstreamStorageService();
        String sIntermediatePath = "";
        if (bitstreamStorageService.isRegisteredBitstream(sInternalId)) {
            sInternalId = sInternalId.substring(2);
        } else {
            sInternalId = this.sanitizeIdentifier(sInternalId);
            sIntermediatePath = this.getIntermediatePath(sInternalId);
        }
        return sIntermediatePath + sInternalId;
    }

    private void deleteParents(File file) {
        if (file == null) {
            return;
        }
        BlobStore blobStore = this.blobStoreContext.getBlobStore();
        for (int i = 0; i < 3; ++i) {
            File directory = file.getParentFile();
            ListContainerOptions options = new ListContainerOptions();
            options.inDirectory(directory.getPath());
            long blobs = blobStore.countBlobs(this.getContainer(), options);
            if (blobs != 0L) break;
            blobStore.deleteDirectory(this.getContainer(), directory.getPath());
            file = directory;
        }
    }

    public void put(ByteSource byteSource, Bitstream bitstream) throws IOException {
        String container;
        BlobStore blobStore;
        String key = this.getFullKey(bitstream.getInternalId());
        String type = MediaType.OCTET_STREAM.toString();
        if (byteSource instanceof BitstreamByteSource) {
            type = JCloudBitStoreService.getMIMEType(((BitstreamByteSource)byteSource).getBitstream());
        }
        if (!(blobStore = this.blobStoreContext.getBlobStore()).containerExists(container = this.getContainer())) {
            blobStore.createContainerInLocation(null, container);
        }
        Blob blob = blobStore.blobBuilder(key).payload(byteSource).contentDisposition(key).contentLength(byteSource.size()).contentType(type).build();
        blobStore.putBlob(container, blob, PutOptions.Builder.multipart());
    }

    @Override
    public void put(Bitstream bitstream, InputStream in) throws IOException {
        String key = this.getFullKey(bitstream.getInternalId());
        File scratchFile = File.createTempFile(bitstream.getInternalId(), "s3bs");
        try {
            FileUtils.copyInputStreamToFile((InputStream)in, (File)scratchFile);
            long contentLength = scratchFile.length();
            String localChecksum = Utils.checksum(scratchFile, CSA);
            this.put(Files.asByteSource((File)scratchFile), bitstream);
            bitstream.setSizeBytes(contentLength);
            bitstream.setChecksum(localChecksum);
            bitstream.setChecksumAlgorithm(CSA);
        }
        catch (Exception e) {
            log.error("put(" + bitstream.getInternalId() + ", is)", (Throwable)e);
            throw new IOException(e);
        }
        finally {
            if (!scratchFile.delete()) {
                scratchFile.deleteOnExit();
            }
        }
    }

    public static String getMIMEType(Bitstream bitstream) {
        try {
            BitstreamFormat format = bitstream.getFormat(new Context());
            return format == null ? null : format.getMIMEType();
        }
        catch (SQLException ignored) {
            throw new RuntimeException(ignored);
        }
    }

    @Override
    public Map<String, Object> about(Bitstream bitstream, List<String> attrs) throws IOException {
        File file = this.getFile(bitstream);
        BlobStore blobStore = this.blobStoreContext.getBlobStore();
        BlobMetadata blobMetadata = blobStore.blobMetadata(this.getContainer(), file.toString());
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        if (blobMetadata != null) {
            ContentMetadata contentMetadata = blobMetadata.getContentMetadata();
            if (contentMetadata != null) {
                metadata.put("size_bytes", String.valueOf(contentMetadata.getContentLength()));
                HashCode hashCode = contentMetadata.getContentMD5AsHashCode();
                if (hashCode != null) {
                    metadata.put("checksum", org.dspace.core.Utils.toHex(contentMetadata.getContentMD5AsHashCode().asBytes()));
                    metadata.put("checksum_algorithm", CSA);
                }
                metadata.put("modified", String.valueOf(blobMetadata.getLastModified().getTime()));
                metadata.put("ContentDisposition", contentMetadata.getContentDisposition());
                metadata.put("ContentEncoding", contentMetadata.getContentEncoding());
                metadata.put("ContentLanguage", contentMetadata.getContentLanguage());
                metadata.put("ContentType", contentMetadata.getContentType());
                if (contentMetadata.getExpires() != null) {
                    metadata.put("Expires", contentMetadata.getExpires().getTime());
                }
            }
            return metadata;
        }
        return null;
    }

    public File getFile(Bitstream bitstream) throws IOException {
        String id = bitstream.getInternalId();
        id = this.getFullKey(id);
        if (log.isDebugEnabled()) {
            log.debug("Local filename for " + bitstream.getInternalId() + " is " + id);
        }
        return new File(id);
    }

    private String getContainer() {
        return this.container;
    }
}

