/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.bitstore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.core.Utils;
import org.dspace.storage.bitstore.BaseBitStoreService;

public class DSBitStoreService
extends BaseBitStoreService {
    private static Logger log = LogManager.getLogger(DSBitStoreService.class);
    private File baseDir;
    protected final String REGISTERED_FLAG = "-R";

    @Override
    public void init() {
        this.initialized = true;
    }

    @Override
    public String generateId() {
        return Utils.generateKey();
    }

    @Override
    public InputStream get(Bitstream bitstream) throws IOException {
        try {
            return new FileInputStream(this.getFile(bitstream));
        }
        catch (Exception e) {
            log.error("get(" + bitstream.getInternalId() + ")", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public void put(Bitstream bitstream, InputStream in) throws IOException {
        try {
            File file = this.getFile(bitstream);
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            file.createNewFile();
            try (FileOutputStream fos = new FileOutputStream(file);
                 DigestInputStream dis = new DigestInputStream(in, MessageDigest.getInstance("MD5"));){
                Utils.bufferedCopy(dis, fos);
                in.close();
                bitstream.setSizeBytes(file.length());
                bitstream.setChecksum(Utils.toHex(dis.getMessageDigest().digest()));
                bitstream.setChecksumAlgorithm("MD5");
            }
            catch (NoSuchAlgorithmException nsae) {
                log.warn("Caught NoSuchAlgorithmException", (Throwable)nsae);
            }
        }
        catch (Exception e) {
            log.error("put(" + bitstream.getInternalId() + ", inputstream)", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public Map<String, Object> about(Bitstream bitstream, List<String> attrs) throws IOException {
        try {
            File file = this.getFile(bitstream);
            if (file != null && file.exists()) {
                return super.about(file, attrs);
            }
            return null;
        }
        catch (Exception e) {
            log.error("about(" + bitstream.getInternalId() + ")", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public void remove(Bitstream bitstream) throws IOException {
        try {
            File file = this.getFile(bitstream);
            if (file != null) {
                if (file.delete()) {
                    DSBitStoreService.deleteParents(file);
                }
            } else {
                log.warn("Attempt to remove non-existent asset. ID: " + bitstream.getInternalId());
            }
        }
        catch (Exception e) {
            log.error("remove(" + bitstream.getInternalId() + ")", (Throwable)e);
            throw new IOException(e);
        }
    }

    private static synchronized void deleteParents(File file) {
        File directory;
        File[] files;
        if (file == null) {
            return;
        }
        File tmp = file;
        for (int i = 0; i < 3 && (files = (directory = tmp.getParentFile()).listFiles()).length == 0; ++i) {
            directory.delete();
            tmp = directory;
        }
    }

    protected File getFile(Bitstream bitstream) throws IOException {
        if (bitstream == null) {
            return null;
        }
        String sInternalId = bitstream.getInternalId();
        String sIntermediatePath = null;
        if (this.isRegisteredBitstream(sInternalId)) {
            sInternalId = sInternalId.substring("-R".length());
            sIntermediatePath = "";
        } else {
            sInternalId = this.sanitizeIdentifier(sInternalId);
            sIntermediatePath = this.getIntermediatePath(sInternalId);
        }
        StringBuilder bufFilename = new StringBuilder();
        bufFilename.append(this.baseDir.getCanonicalFile());
        bufFilename.append(File.separator);
        bufFilename.append(sIntermediatePath);
        bufFilename.append(sInternalId);
        if (log.isDebugEnabled()) {
            log.debug("Local filename for " + sInternalId + " is " + bufFilename.toString());
        }
        return new File(bufFilename.toString());
    }

    public boolean isRegisteredBitstream(String internalId) {
        return internalId.startsWith("-R");
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }
}

