/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.content;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import org.dspace.statistics.content.DatasetGenerator;

public class DatasetTimeGenerator
extends DatasetGenerator {
    private String type = "time";
    private String dateType;
    private String startDate;
    private String endDate;
    private LocalDateTime actualStartDate;
    private LocalDateTime actualEndDate;

    public void setDateInterval(String dateType, String start, String end) {
        this.startDate = start;
        this.endDate = end;
        this.dateType = dateType;
    }

    public void setDateInterval(String dateType, LocalDateTime start, LocalDateTime end) throws IllegalArgumentException {
        this.actualStartDate = start;
        this.actualEndDate = end;
        this.dateType = dateType;
        if (end.isBefore(start)) {
            throw new IllegalArgumentException("End date is before start date");
        }
        ChronoUnit typeChronoUnit = ChronoUnit.DAYS;
        if ("year".equalsIgnoreCase(dateType)) {
            typeChronoUnit = ChronoUnit.YEARS;
        } else if ("month".equalsIgnoreCase(dateType)) {
            typeChronoUnit = ChronoUnit.MONTHS;
        } else if ("day".equalsIgnoreCase(dateType)) {
            typeChronoUnit = ChronoUnit.DAYS;
        } else if ("hour".equalsIgnoreCase(dateType)) {
            typeChronoUnit = ChronoUnit.HOURS;
        }
        long difStart = typeChronoUnit.between(start, LocalDateTime.now());
        long difEnd = typeChronoUnit.between(end, LocalDateTime.now());
        boolean endPos = false;
        if (difEnd == 0L) {
            difEnd = 1L;
            endPos = true;
        } else if (0L < difEnd) {
            endPos = true;
        } else {
            ++difEnd;
        }
        this.startDate = "" + difStart;
        this.endDate = (endPos ? "+" : "") + difEnd;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getDateType() {
        return this.dateType.toUpperCase();
    }

    public LocalDateTime getActualStartDate() {
        return this.actualStartDate;
    }

    public void setActualStartDate(LocalDateTime actualStartDate) {
        this.actualStartDate = actualStartDate;
    }

    public LocalDateTime getActualEndDate() {
        return this.actualEndDate;
    }

    public void setActualEndDate(LocalDateTime actualEndDate) {
        this.actualEndDate = actualEndDate;
    }

    public void setDateType(String dateType) {
        this.dateType = dateType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

