/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.negotiation;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.rdf.negotiation.Negotiator;
import org.dspace.services.factory.DSpaceServicesFactory;

public class NegotiationFilter
implements Filter {
    public static final String ACCEPT_HEADER_NAME = "Accept";
    private static final Logger log = LogManager.getLogger(NegotiationFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Pattern pathPattern;
        Matcher pathMatcher;
        try {
            if (!DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("rdf.contentNegotiation.enable", false)) {
                chain.doFilter(request, response);
                return;
            }
        }
        catch (Exception ex) {
            log.warn("Will deliver HTML, as I cannot determine if content negotiation should be enabled or not:\n" + ex.getMessage(), (Throwable)ex);
            chain.doFilter(request, response);
            return;
        }
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest hrequest = (HttpServletRequest)request;
        HttpServletResponse hresponse = (HttpServletResponse)response;
        String acceptHeader = hrequest.getHeader(ACCEPT_HEADER_NAME);
        String handle = null;
        String extraPathInfo = null;
        String path = hrequest.getPathInfo();
        Pattern handleCheckPattern = Pattern.compile("^/*handle/(.*)$");
        Matcher handleCheckMatcher = handleCheckPattern.matcher(path);
        if (handleCheckMatcher.matches()) {
            path = handleCheckMatcher.group(1);
        }
        log.debug("PathInfo: " + path);
        if (path == null) {
            path = "";
        }
        if ((pathMatcher = (pathPattern = Pattern.compile("^/*([^/]+)/+([^/]+)(?:/*||/+(.*))?$")).matcher(path)).matches()) {
            handle = pathMatcher.group(1) + "/" + pathMatcher.group(2);
            extraPathInfo = pathMatcher.group(3);
        }
        log.debug("handle: " + handle + "\nextraPathInfo: " + extraPathInfo);
        int requestedContent = Negotiator.negotiate(acceptHeader);
        if (!Negotiator.sendRedirect(hresponse, handle, extraPathInfo, requestedContent, false)) {
            hresponse.setHeader("Vary", ACCEPT_HEADER_NAME);
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

