/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.factory;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.dspace.matomo.factory.MatomoRequestDetailsEnricher;
import org.dspace.matomo.model.MatomoRequestDetails;
import org.dspace.usage.UsageEvent;

public class MatomoRequestTrackerIdentifierParamEnricher
implements MatomoRequestDetailsEnricher {
    public static final String ID_REGEX = "(^([a-f]|[0-9]){16})";
    static final String TRACKER_ID = "trackerId";
    static final String VISITOR_IDENTIFIER = "_id";

    @Override
    public MatomoRequestDetails enrich(UsageEvent usageEvent, MatomoRequestDetails matomoRequestDetails) {
        if (usageEvent == null || usageEvent.getRequest() == null) {
            return matomoRequestDetails;
        }
        Map parameterMap = usageEvent.getRequest().getParameterMap();
        Optional<String> validParameterValue = this.getValidParameterValue(parameterMap);
        if (validParameterValue.isEmpty()) {
            return matomoRequestDetails;
        }
        return matomoRequestDetails.addParameter(VISITOR_IDENTIFIER, validParameterValue.get());
    }

    private Optional<String> getValidParameterValue(Map<String, String[]> parameterMap) {
        return parameterMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(TRACKER_ID)).flatMap(entry -> Arrays.stream((String[])entry.getValue()).filter(value -> value.matches(ID_REGEX))).findFirst();
    }
}

