/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.openaire.service;

import jakarta.el.MethodNotFoundException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.service.AbstractImportMetadataSourceService;
import org.dspace.importer.external.service.components.QuerySource;
import org.dspace.services.ConfigurationService;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OpenAireImportMetadataSourceServiceImpl
extends AbstractImportMetadataSourceService<Element>
implements QuerySource {
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    private String baseAddress;
    private WebTarget webTarget;
    private String queryParam;

    @Override
    public String getImportSource() {
        return "openaire";
    }

    @Override
    public ImportRecord getRecord(String id) throws MetadataSourceException {
        return this.retry(new SearchByIdCallable(id));
    }

    @Override
    public ImportRecord getRecord(Query query) throws MetadataSourceException {
        return this.retry(new SearchByIdCallable(query));
    }

    @Override
    public int getRecordsCount(String query) throws MetadataSourceException {
        return this.retry(new CountByQueryCallable(query));
    }

    @Override
    public int getRecordsCount(Query query) throws MetadataSourceException {
        return this.retry(new CountByQueryCallable(query));
    }

    @Override
    public Collection<ImportRecord> getRecords(String query, int start, int count) throws MetadataSourceException {
        return this.retry(new SearchByQueryCallable(query, start, count));
    }

    @Override
    public Collection<ImportRecord> getRecords(Query query) throws MetadataSourceException {
        return this.retry(new SearchByQueryCallable(query));
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Query query) throws MetadataSourceException {
        throw new MethodNotFoundException("This method is not implemented for OpenAIRE");
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Item item) throws MetadataSourceException {
        throw new MethodNotFoundException("This method is not implemented for OpenAIRE");
    }

    public void setBaseAddress(String baseAddress) {
        this.baseAddress = baseAddress;
    }

    public String getBaseAddress() {
        return this.baseAddress;
    }

    public void setQueryParam(String queryParam) {
        this.queryParam = queryParam;
    }

    public String getQueryParam() {
        return this.queryParam;
    }

    @Override
    public void init() throws Exception {
        Client client = ClientBuilder.newClient();
        if (this.baseAddress == null) {
            this.baseAddress = this.configurationService.getProperty("openaire.search.url", "https://api.openaire.eu/search/publications");
        }
        if (this.queryParam == null) {
            this.queryParam = "title";
        }
        this.webTarget = client.target(this.baseAddress);
    }

    private ImportRecord filterMultipleTitles(ImportRecord transformSourceRecords) {
        List<MetadatumDTO> metadata = transformSourceRecords.getValueList();
        ArrayList<MetadatumDTO> nextSourceRecord = new ArrayList<MetadatumDTO>();
        boolean found = false;
        for (MetadatumDTO dto : metadata) {
            if ("dc".equals(dto.getSchema()) && "title".equals(dto.getElement()) && dto.getQualifier() == null) {
                if (found) continue;
                nextSourceRecord.add(dto);
                found = true;
                continue;
            }
            nextSourceRecord.add(dto);
        }
        return new ImportRecord(nextSourceRecord);
    }

    private List<Element> splitToRecords(String recordsSrc) {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            Document document = saxBuilder.build((Reader)new StringReader(recordsSrc));
            Element root = document.getRootElement();
            List<Namespace> namespaces = Arrays.asList(Namespace.getNamespace((String)"dri", (String)"http://www.driver-repository.eu/namespace/dri"), Namespace.getNamespace((String)"oaf", (String)"http://namespace.openaire.eu/oaf"), Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
            XPathExpression xpath = XPathFactory.instance().compile("//results/result", Filters.element(), null, namespaces);
            List recordsList = xpath.evaluate((Object)root);
            return recordsList;
        }
        catch (IOException | JDOMException e) {
            return null;
        }
    }

    public class SearchByIdCallable
    implements Callable<ImportRecord> {
        String id = null;

        public SearchByIdCallable(String id) {
            this.id = id;
        }

        public SearchByIdCallable(Query query) {
            this.id = query.getParameterAsClass("id", String.class);
        }

        @Override
        public ImportRecord call() throws Exception {
            ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
            WebTarget localTarget = OpenAireImportMetadataSourceServiceImpl.this.webTarget.queryParam("openairePublicationID", new Object[]{this.id});
            Invocation.Builder invocationBuilder = localTarget.request();
            Response response = invocationBuilder.get();
            if (response.getStatus() == 200) {
                String responseString = (String)response.readEntity(String.class);
                List<Element> omElements = OpenAireImportMetadataSourceServiceImpl.this.splitToRecords(responseString);
                if (omElements != null) {
                    for (Element record : omElements) {
                        results.add(OpenAireImportMetadataSourceServiceImpl.this.filterMultipleTitles(OpenAireImportMetadataSourceServiceImpl.this.transformSourceRecords(record)));
                    }
                }
                return results != null ? (ImportRecord)results.get(0) : null;
            }
            return null;
        }
    }

    public class CountByQueryCallable
    implements Callable<Integer> {
        String q;

        public CountByQueryCallable(String query) {
            this.q = query;
        }

        public CountByQueryCallable(Query query) {
            this.q = query.getParameterAsClass("query", String.class);
        }

        @Override
        public Integer call() throws Exception {
            WebTarget localTarget = OpenAireImportMetadataSourceServiceImpl.this.webTarget.queryParam(OpenAireImportMetadataSourceServiceImpl.this.queryParam, new Object[]{this.q});
            Invocation.Builder invocationBuilder = localTarget.request();
            Response response = invocationBuilder.get();
            if (response.getStatus() == 200) {
                String responseString = (String)response.readEntity(String.class);
                SAXBuilder saxBuilder = new SAXBuilder();
                Document document = saxBuilder.build((Reader)new StringReader(responseString));
                Element root = document.getRootElement();
                XPathExpression xpath = XPathFactory.instance().compile("//header/total", Filters.element(), null, new Namespace[0]);
                Element totalItem = (Element)xpath.evaluateFirst((Object)root);
                return totalItem != null ? Integer.valueOf(Integer.parseInt(totalItem.getText())) : null;
            }
            return 0;
        }
    }

    public class SearchByQueryCallable
    implements Callable<List<ImportRecord>> {
        String q;
        int page;
        int count;

        public SearchByQueryCallable(String query, int start, int count) {
            this.q = query;
            this.page = start / count;
            this.count = count;
        }

        public SearchByQueryCallable(Query query) {
            this.q = query.getParameterAsClass("query", String.class);
            this.page = query.getParameterAsClass("start", Integer.class) / query.getParameterAsClass("count", Integer.class);
            this.count = query.getParameterAsClass("count", Integer.class);
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            String responseString;
            List<Element> omElements;
            WebTarget localTarget = OpenAireImportMetadataSourceServiceImpl.this.webTarget.queryParam(OpenAireImportMetadataSourceServiceImpl.this.queryParam, new Object[]{this.q});
            localTarget = localTarget.queryParam("page", new Object[]{this.page + 1});
            localTarget = localTarget.queryParam("size", new Object[]{this.count});
            ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
            Invocation.Builder invocationBuilder = localTarget.request();
            Response response = invocationBuilder.get();
            if (response.getStatus() == 200 && (omElements = OpenAireImportMetadataSourceServiceImpl.this.splitToRecords(responseString = (String)response.readEntity(String.class))) != null) {
                for (Element record : omElements) {
                    results.add(OpenAireImportMetadataSourceServiceImpl.this.filterMultipleTitles(OpenAireImportMetadataSourceServiceImpl.this.transformSourceRecords(record)));
                }
            }
            return results;
        }
    }
}

