/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadataFieldMapping;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.MetadataContributor;

public class SimpleRisToMetadataContributor
implements MetadataContributor<Map<String, List<String>>> {
    protected Map<String, MetadataFieldConfig> fieldToMetadata;
    protected MetadataFieldMapping<Map<String, List<String>>, MetadataContributor<Map<String, List<String>>>> metadataFieldMapping;

    public SimpleRisToMetadataContributor() {
    }

    public SimpleRisToMetadataContributor(Map<String, MetadataFieldConfig> fieldToMetadata) {
        this.fieldToMetadata = fieldToMetadata;
    }

    @Override
    public Collection<MetadatumDTO> contributeMetadata(Map<String, List<String>> record) {
        LinkedList<MetadatumDTO> values = new LinkedList<MetadatumDTO>();
        for (String field : this.fieldToMetadata.keySet()) {
            List<String> fieldValues = record.get(field);
            if (!Objects.nonNull(fieldValues)) continue;
            for (String value : fieldValues) {
                values.add(this.metadataFieldMapping.toDCValue(this.fieldToMetadata.get(field), value));
            }
        }
        return values;
    }

    public Map<String, MetadataFieldConfig> getFieldToMetadata() {
        return this.fieldToMetadata;
    }

    public void setFieldToMetadata(Map<String, MetadataFieldConfig> fieldToMetadata) {
        this.fieldToMetadata = fieldToMetadata;
    }

    public MetadataFieldMapping<Map<String, List<String>>, MetadataContributor<Map<String, List<String>>>> getMetadataFieldMapping() {
        return this.metadataFieldMapping;
    }

    @Override
    public void setMetadataFieldMapping(MetadataFieldMapping<Map<String, List<String>>, MetadataContributor<Map<String, List<String>>>> metadataFieldMapping) {
        this.metadataFieldMapping = metadataFieldMapping;
    }
}

